/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.jgroups.Address;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.FailureDetection;
import org.jgroups.util.Util;

public class FD_ALL3
extends FailureDetection {
    protected final Map<Address, Bitmap> timestamps = Util.createConcurrentMap();
    @ManagedAttribute(description="The number of bits for each member (timeout / interval)")
    protected int num_bits;

    @Override
    protected Map<Address, ?> getTimestamps() {
        return this.timestamps;
    }

    @Override
    protected long getTimeoutCheckInterval() {
        return this.interval;
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this._printTimestamps();
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.interval >= this.timeout) {
            throw new IllegalStateException("interval needs to be smaller than timeout");
        }
        this.num_bits = this.timeout % this.interval == 0L ? (int)(this.timeout / this.interval) : (int)(this.timeout / this.interval + 1L);
    }

    @Override
    protected void update(Address sender, boolean log_msg, boolean skip_if_exists) {
        if (sender != null && !sender.equals(this.local_addr)) {
            Bitmap bm = this.timestamps.get(sender);
            if (bm != null) {
                if (!skip_if_exists) {
                    bm.set();
                }
            } else {
                this.timestamps.putIfAbsent(sender, new Bitmap(this.num_bits));
            }
        }
        if (log_msg && this.log.isTraceEnabled()) {
            this.log.trace("%s: received heartbeat from %s", this.local_addr, sender);
        }
    }

    @Override
    protected <T> boolean needsToBeSuspected(Address mbr, T value) {
        Bitmap bm = (Bitmap)value;
        boolean suspect = bm.needsToSuspect();
        bm.advance();
        if (suspect) {
            this.log.debug("%s: haven't received a heartbeat from %s in timeout period (%d ms), adding it to suspect list", this.local_addr, mbr, this.timeout);
            return true;
        }
        return false;
    }

    @Override
    protected String getTimeoutCheckerInfo() {
        return FD_ALL3.class.getSimpleName() + ": " + this.getClass().getSimpleName() + " (timeout=" + this.timeout + " ms)";
    }

    protected String _printTimestamps() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Bitmap> entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": bitmap=").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class Bitmap {
        protected volatile int index;
        protected final AtomicIntegerArray bits;

        public Bitmap(int size) {
            this.bits = new AtomicIntegerArray(size);
            for (int i = 0; i < size; ++i) {
                this.bits.set(i, 1);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public boolean needsToSuspect() {
            for (int i = 0; i < this.bits.length(); ++i) {
                if (this.bits.get(i) != 1) continue;
                return false;
            }
            return true;
        }

        public Bitmap advance() {
            int new_index = (this.index + 1) % this.bits.length();
            this.bits.set(new_index, 0);
            this.index = new_index;
            return this;
        }

        public Bitmap set() {
            this.bits.set(this.index, 1);
            return this;
        }

        public String toString() {
            if (this.bits.length() < Util.MAX_LIST_PRINT_SIZE) {
                return this.toStringDetailed();
            }
            int set = 0;
            for (int i = 0; i < this.bits.length(); ++i) {
                if (this.bits.get(i) != 1) continue;
                ++set;
            }
            return String.format("[%d 1s %d 0s] (index: %d)", set, this.bits.length() - set, this.index);
        }

        public String toStringDetailed() {
            return String.format("%s (index=%d)", this.bits, this.index);
        }
    }
}

