/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.scheduler.BasicThreadFactory;
import org.lsst.ccs.utilities.scheduler.PeriodicTaskExceptionHandler;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class PeriodicTask
implements Runnable,
ScheduledFuture<Void> {
    private static final ScheduledThreadPoolExecutor LONG_TASK_DETECTOR = new ScheduledThreadPoolExecutor(2, new BasicThreadFactory("Scheduler long task detector", null, true));
    private static final SuspendedTask STOPPED = new SuspendedTask();
    private final Scheduler scheduler;
    private final Runnable runner;
    private final boolean isFixedRate;
    private final String name;
    private final PeriodicTaskExceptionHandler exceptionHandler;
    private volatile ScheduledFuture<?> delegate;
    private long period;
    private boolean isStopped;
    private int failures;
    private int skipped;
    private final CountDownLatch cancelLatch = new CountDownLatch(1);
    volatile Thread thread;
    volatile long timeBegin;
    volatile long timeBeforeOnSkippedExecutions;
    volatile long timeAfterOnSkippedExecutions;
    volatile long timeBeforeTimer;
    volatile long timeAfterTimer;
    volatile long timeBeforeRun;
    volatile long timeAfterRun;
    volatile long timeBeforeCancel;
    volatile long timeEnd;
    volatile long timeFirstSkipped;
    volatile long delayFirstSkipped;

    public PeriodicTask(Scheduler scheduler, Runnable runnable, boolean isFixedRate, String taskName, long period, TimeUnit unit, PeriodicTaskExceptionHandler exceptionHandler) {
        if (scheduler == null || runnable == null) {
            throw new NullPointerException();
        }
        this.scheduler = scheduler;
        this.runner = runnable;
        this.isFixedRate = isFixedRate;
        this.name = taskName == null ? "" : taskName;
        this.exceptionHandler = exceptionHandler;
        if (exceptionHandler.getLevel() == null) {
            exceptionHandler.setLevel(scheduler.getDefaultLogLevel());
        }
        this.period = period > 0L ? unit.toNanos(period) : 0L;
        this.isStopped = true;
        this.delegate = STOPPED;
        if (exceptionHandler.getMaxFailures() == -1) {
            exceptionHandler.setMaxFailures(scheduler.maxFailures);
        }
    }

    public PeriodicTask(Scheduler scheduler, Runnable runnable, boolean isFixedRate, String taskName, Level logLevel, long period, TimeUnit unit) {
        if (scheduler == null || runnable == null) {
            throw new NullPointerException();
        }
        this.scheduler = scheduler;
        this.runner = runnable;
        this.isFixedRate = isFixedRate;
        this.name = taskName == null ? "" : taskName;
        this.exceptionHandler = new PeriodicTaskExceptionHandler();
        this.exceptionHandler.setLevel(logLevel == null ? scheduler.getDefaultLogLevel() : logLevel);
        this.period = period > 0L ? unit.toNanos(period) : 0L;
        this.isStopped = true;
        this.delegate = STOPPED;
        if (this.exceptionHandler.getMaxFailures() == -1) {
            this.exceptionHandler.setMaxFailures(scheduler.maxFailures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            long time = System.currentTimeMillis();
            this.thread = Thread.currentThread();
            long timeB = 0L;
            long timeA = 0L;
            if (this.isFixedRate && this.exceptionHandler.isSkipOverdueExecutions()) {
                try {
                    long d = this.getDelay(TimeUnit.NANOSECONDS);
                    if (d < -this.period / 2L) {
                        ++this.skipped;
                        if (this.skipped == 1) {
                            this.timeFirstSkipped = System.currentTimeMillis();
                            this.delayFirstSkipped = d / 1000000L;
                        }
                        return;
                    }
                    if (this.skipped > 0) {
                        timeB = System.currentTimeMillis();
                        this.exceptionHandler.onSkippedExecutions(this, this.skipped);
                        timeA = System.currentTimeMillis();
                        this.skipped = 0;
                    }
                }
                catch (Throwable d) {
                    // empty catch block
                }
            }
            this.timeBegin = time;
            this.timeBeforeOnSkippedExecutions = timeB;
            this.timeAfterOnSkippedExecutions = timeA;
            ScheduledFuture<?> longRunDetector = null;
            try {
                if (this.exceptionHandler.isDetectLongExecutions()) {
                    this.timeBeforeTimer = System.currentTimeMillis();
                    int threshold = this.exceptionHandler.getLongExecutionThreshold();
                    longRunDetector = threshold > 0 ? LONG_TASK_DETECTOR.schedule(() -> this.exceptionHandler.onLongExecution(this), (long)threshold, TimeUnit.MILLISECONDS) : LONG_TASK_DETECTOR.schedule(() -> this.exceptionHandler.onLongExecution(this), this.period * (long)(-threshold), TimeUnit.NANOSECONDS);
                    this.timeAfterTimer = System.currentTimeMillis();
                }
                this.timeBeforeRun = System.currentTimeMillis();
                this.runner.run();
                this.timeAfterRun = System.currentTimeMillis();
                if (this.exceptionHandler.isResetFailureCountOnSuccess()) {
                    this.failures = 0;
                }
            }
            catch (Throwable t) {
                if (this.exceptionHandler.getMaxFailures() < 0 || ++this.failures < this.exceptionHandler.getMaxFailures()) {
                    this.exceptionHandler.onException(this, t);
                    break block21;
                }
                this.exceptionHandler.onFinalException(this, t);
                throw t;
            }
            finally {
                try {
                    if (longRunDetector != null) {
                        this.timeBeforeCancel = System.currentTimeMillis();
                        longRunDetector.cancel(false);
                    }
                }
                catch (Throwable threshold) {}
                this.timeEnd = System.currentTimeMillis();
                this.thread = null;
            }
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getMaxFailures() {
        return this.exceptionHandler.getMaxFailures();
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.delegate.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.delegate.compareTo(o);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelLatch.countDown();
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelLatch.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.cancelLatch.getCount() == 0L || this.delegate.isDone();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this.cancelLatch.await();
        this.delegate.get();
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = unit.toNanos(timeout) + System.nanoTime();
        this.cancelLatch.await(timeout, unit);
        this.delegate.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
        return null;
    }

    public void setMaxFailures(int maxFailures) {
        this.exceptionHandler.setMaxFailures(maxFailures);
    }

    public synchronized void setPeriod(long period, TimeUnit unit) {
        this.delegate.cancel(false);
        this.delegate = STOPPED;
        if (period > 0L) {
            this.period = unit.toNanos(period);
            if (!this.isStopped) {
                this.isStopped = true;
                this.start();
            }
        } else {
            this.period = 0L;
        }
    }

    public synchronized long getPeriod(TimeUnit unit) {
        return unit.convert(this.period, TimeUnit.NANOSECONDS);
    }

    public synchronized void stop() {
        if (!this.isStopped) {
            this.isStopped = true;
            this.delegate.cancel(false);
            this.delegate = STOPPED;
        }
    }

    public synchronized void stop(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.isStopped) {
            this.isStopped = true;
            this.delegate.cancel(false);
            ScheduledFuture<?> old = this.delegate;
            this.delegate = STOPPED;
            try {
                old.get(timeout, unit);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean start() {
        return this.start(0L, TimeUnit.NANOSECONDS);
    }

    public synchronized boolean start(long initialDelay, TimeUnit unit) {
        if (this.isStopped) {
            this.isStopped = false;
            if (this.period > 0L) {
                initialDelay = unit.toNanos(initialDelay);
                this.delegate = this.isFixedRate ? this.scheduler.executor.scheduleAtFixedRate(this, initialDelay, this.period, TimeUnit.NANOSECONDS) : this.scheduler.executor.scheduleWithFixedDelay(this, initialDelay, this.period, TimeUnit.NANOSECONDS);
                return true;
            }
        }
        return false;
    }

    public String getTaskName() {
        return this.name;
    }

    public Logger getLog() {
        return this.scheduler.log;
    }

    @Deprecated
    public org.lsst.ccs.utilities.logging.Logger getLogger() {
        return this.scheduler.getLogger();
    }

    public Level getLogLevel() {
        return this.exceptionHandler.getLevel();
    }

    public static void main(String ... args) {
        System.out.println("Start...");
        long t = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            long tt = System.currentTimeMillis();
            if (tt - t > 2L) {
                System.out.println(i + " " + (tt - t));
                t = System.currentTimeMillis();
                continue;
            }
            t = tt;
        }
        System.out.println("Done");
    }

    private static class SuspendedTask
    implements ScheduledFuture<Void> {
        private SuspendedTask() {
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

