/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.util.VersionComparator;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.config.SingleCategoryTag;

public class SingleCategoryTagData {
    private static final Logger LOG = Logger.getLogger(SingleCategoryTagData.class.getName());
    private final SingleCategoryTag singleCategoryTag;
    private final Map<String, String> comments = new ConcurrentHashMap<String, String>();
    private final Map<String, String> conditions = new ConcurrentHashMap<String, String>();
    private final Map<String, String> data = Collections.synchronizedMap(new LinkedHashMap());
    private boolean needsSaving = false;

    public SingleCategoryTagData(SingleCategoryTag singleCategoryTag) {
        this.singleCategoryTag = singleCategoryTag;
    }

    public SingleCategoryTagData(SingleCategoryTagData singleCategoryTagData) {
        this.singleCategoryTag = new SingleCategoryTag(singleCategoryTagData.singleCategoryTag);
        this.comments.putAll(singleCategoryTagData.comments);
        this.conditions.putAll(singleCategoryTagData.conditions);
        this.data.putAll(singleCategoryTagData.data);
    }

    public SingleCategoryTag getSingleCategoryTag() {
        return this.singleCategoryTag;
    }

    public Map<String, String> getConfigurationData() {
        return this.data;
    }

    public Map<String, String> getConfigurationDataForAgent(AgentInfo agentInfo) {
        LinkedHashMap<String, String> dataForAgent = new LinkedHashMap<String, String>();
        for (String key : this.data.keySet()) {
            String condition = this.getConditionParameter(key);
            if (condition != null && !this.acceptConditionForAgent(condition, agentInfo)) continue;
            dataForAgent.put(key, this.data.get(key));
        }
        return dataForAgent;
    }

    private boolean acceptConditionForAgent(String condition, AgentInfo ai) {
        String[] conditionComponents = condition.replace("[", "").replace("]", "").trim().split(" ");
        if (conditionComponents.length != 3) {
            throw new RuntimeException("Invalid condition " + condition);
        }
        String versionType = conditionComponents[0].trim();
        String operand = conditionComponents[1].trim();
        String versionValue = conditionComponents[2].trim();
        String currentVersionValue = ai.getAgentProperty(versionType).replace("-SNAPSHOT", "");
        if (currentVersionValue == null) {
            throw new RuntimeException("Could not find current version for \"" + versionType + "\" in " + ai.getAgentProperties());
        }
        int comparison = VersionComparator.compareVersion((String)currentVersionValue, (String)versionValue);
        if (comparison == 0 && operand.contains("=")) {
            return true;
        }
        if (comparison > 0 && operand.contains(">")) {
            return true;
        }
        return comparison < 0 && operand.contains("<");
    }

    public String getCommentParameter(String prop) {
        return this.comments.get(prop);
    }

    public String getConditionParameter(String prop) {
        return this.conditions.get(prop);
    }

    public void mergeSingleCategoryTagData(SingleCategoryTagData inputData) {
        if (inputData == null) {
            return;
        }
        if (!inputData.singleCategoryTag.equals((Object)this.singleCategoryTag)) {
            throw new RuntimeException("It's not possible to merge the data from different category tags. Merging input: " + inputData.singleCategoryTag + " onto " + this.singleCategoryTag);
        }
        this.comments.putAll(inputData.comments);
        this.data.putAll(inputData.data);
    }

    public void load(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String comment = "";
            String condition = "";
            while (reader.ready()) {
                String line = reader.readLine();
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#") || trimmedLine.startsWith("!")) {
                    comment = comment + line + "\n";
                    continue;
                }
                if (trimmedLine.startsWith("[")) {
                    if (condition.isEmpty()) {
                        condition = line;
                        continue;
                    }
                    throw new RuntimeException("We currently support only one condition for configuration parameter. Please remove either " + condition + " or " + line);
                }
                int propertyEnd = trimmedLine.indexOf("=");
                if (propertyEnd < 0) {
                    propertyEnd = trimmedLine.indexOf(":");
                }
                if (propertyEnd < 0) {
                    propertyEnd = trimmedLine.length() - 1;
                }
                if (propertyEnd < 0) {
                    if (trimmedLine.isEmpty()) continue;
                    LOG.log(Level.WARNING, "Skipping line {0}", line);
                    continue;
                }
                String propertyKey = trimmedLine.substring(0, propertyEnd).trim();
                if (!comment.isEmpty()) {
                    this.comments.put(propertyKey, comment);
                    comment = "";
                }
                if (!condition.isEmpty()) {
                    this.conditions.put(propertyKey, condition);
                    condition = "";
                }
                String propertyValue = trimmedLine.substring(propertyEnd + 1).trim();
                this.data.put(propertyKey, propertyValue);
            }
        }
        this.comments.keySet().stream().filter(prop -> !this.data.containsKey(prop)).forEachOrdered(prop -> {
            throw new RuntimeException("Property name " + prop + " does not exist for comment " + this.comments.get(prop));
        });
    }

    public String fullDataString() {
        StringBuilder result = new StringBuilder();
        this.data.keySet().forEach(prop -> {
            String condition;
            String comment = this.getCommentParameter((String)prop);
            if (comment != null) {
                result.append(comment);
            }
            if ((condition = this.getConditionParameter((String)prop)) != null) {
                result.append(condition).append("\n");
            }
            result.append((String)prop).append(" = ").append(this.data.get(prop)).append("\n");
        });
        return result.toString();
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public void removeConfigurationParameter(String parameterPath) {
        this.data.remove(parameterPath);
        this.needsSaving = true;
    }
}

