/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusCommandDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentDictionaryCommand;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;

public class AgentCommandDictionaryService
implements ServiceLifecycle,
AgentService {
    private static final Logger log = Logger.getLogger("org.lsst.ccs.services.commandcitionaryservice");
    private final ConcurrentHashMap<String, CommandSet> commandSetMap = new ConcurrentHashMap();
    HashMap<String, Dictionary> dictionaries = null;
    private byte[] serializedDictionaries;
    private List<String> commandTargets = null;
    private volatile boolean canAddDictionaries = false;
    ClientSideAgentCommandDictionaryBookkeeper bookkeeper;
    private final ConcurrentHashMap<AgentInfo, HashMap<String, Dictionary>> agentDictionaries = new ConcurrentHashMap();
    private final ReentrantLock dictionaryUpdateLock = new ReentrantLock();
    private final ConcurrentHashMap<AgentInfo, Condition> dictionaryWaitConditions = new ConcurrentHashMap();
    private final List<AgentCommandDictionaryListener> listeners = new CopyOnWriteArrayList<AgentCommandDictionaryListener>();
    private ConcurrentMessagingUtils sci;
    private long dictionaryChecksum = -1L;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent topLevelAgent;

    @Override
    public String getAgentServiceName() {
        return "commandDictionaryService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void preInit() {
        this.sci = new ConcurrentMessagingUtils(this.topLevelAgent.getMessagingAccess(), Duration.ofMillis(500L));
        this.canAddDictionaries = true;
    }

    @Override
    public void preStart() {
        AgentInfo agentInfo = this.topLevelAgent.getAgentInfo();
        if (AgentCommandDictionaryService.doesAgentNeedDictionary(agentInfo)) {
            this.bookkeeper = new ClientSideAgentCommandDictionaryBookkeeper();
            this.topLevelAgent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.bookkeeper, BusMessageFilterFactory.messageClass(StatusCommandDictionary.class));
            this.topLevelAgent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.bookkeeper);
            this.agentLockService.addAgentLockUpdateListener(this.bookkeeper);
        }
    }

    private static boolean doesAgentNeedDictionary(AgentInfo agentInfo) {
        return agentInfo.getType() == AgentInfo.AgentType.CONSOLE && !agentInfo.isScriptingConsole();
    }

    @Override
    public void afterStart() {
        this.topLevelAgent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)new AgentPublishDictionaryStrategy());
    }

    @Override
    public void afterInit() {
        TreeWalkerUtils.proceduralNodeWalk(this.topLevelAgent.getComponentLookup(), this.topLevelAgent.getComponentLookup().getComponentNodeForObject((Object)this.topLevelAgent), n -> {
            Object o;
            Object objectToAddTo = o = n.getComponent();
            String key = n.getKey();
            if (o instanceof Monitor || o instanceof ConfigurationService || o instanceof AlertService || o instanceof PersistencyService) {
                objectToAddTo = this.topLevelAgent;
            }
            this.addCommandSetToObject(o, objectToAddTo);
        }, null);
        this.addCommandSetToObject(new AgentCommandDictionaryCommands(), this.topLevelAgent);
        this.dictionaries = new LinkedHashMap<String, Dictionary>(this.commandSetMap.size() * 2);
        this.commandSetMap.forEach((name, commandSet) -> {
            Dictionary dict = commandSet.getCommandDictionary();
            for (Map.Entry<String, Dictionary> d : this.dictionaries.entrySet()) {
                if (!DictionaryUtils.areDictionariesEqual((Dictionary)d.getValue(), (Dictionary)dict)) continue;
                dict = d.getValue();
                break;
            }
            this.dictionaries.put((String)name, dict);
        });
        this.commandTargets = new ArrayList<String>(this.commandSetMap.size() * 2);
        this.commandSetMap.forEach((name, commandSet) -> this.commandTargets.add((String)name));
        this.canAddDictionaries = false;
        this.dictionaryChecksum = ChecksumUtils.evaluateChecksum(this.dictionaries);
        AgentInfo agentInfo = this.topLevelAgent.getAgentInfo();
        agentInfo.getAgentProperties().setProperty(this.getClass().getSimpleName() + ":checksum", String.valueOf(this.dictionaryChecksum));
        String dictionaryType = null;
        if (agentInfo.isGraphicalConsole()) {
            dictionaryType = "console";
        } else if (agentInfo.isScriptingConsole()) {
            dictionaryType = "scripting";
        } else if (agentInfo.getType() == AgentInfo.AgentType.CONSOLE) {
            dictionaryType = "shell";
        }
        if (dictionaryType != null) {
            agentInfo.getAgentProperties().setProperty(this.getClass().getSimpleName() + ":type", dictionaryType);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzipOut = new GZIPOutputStream(bos);){
            try (ObjectOutputStream oos = new ObjectOutputStream(gzipOut);){
                oos.writeObject(this.dictionaries);
                oos.flush();
            }
            this.serializedDictionaries = bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the dictionaries.", ioe);
        }
    }

    public long getDictionaryChecksum() {
        return this.dictionaryChecksum;
    }

    public CommandSet getCommandSet(String name) {
        if (this.commandSetMap.containsKey(name)) {
            return this.commandSetMap.get(name);
        }
        String componentName = name.substring(name.lastIndexOf(47));
        for (Map.Entry<String, CommandSet> entry : this.commandSetMap.entrySet()) {
            if (!entry.getKey().endsWith(componentName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void addCommandSetToObject(Object obj, Object objectToAddTo) {
        String fullPath;
        if (!this.canAddDictionaries) {
            throw new RuntimeException("Not possible to add a CommandSet at this point. Command sets can only be added in the HasLifecycle::init phase.");
        }
        CommandSet commandSet = new CommandSetBuilder().buildCommandSet(obj);
        String string = fullPath = objectToAddTo instanceof String ? (String)objectToAddTo : this.topLevelAgent.getComponentLookup().getComponentNodeForObject(objectToAddTo).getPath();
        if (commandSet.getCommandDictionary().size() == 0) {
            return;
        }
        if (fullPath == null) {
            fullPath = "";
        }
        int depth = !fullPath.isEmpty() ? fullPath.split("/").length : 0;
        Dictionary dict = commandSet.getCommandDictionary();
        for (DictionaryCommand c : dict) {
            for (Field field : c.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    int value;
                    if (!field.getName().equals("level") || (value = ((Integer)field.get(c)).intValue()) != 99999) continue;
                    field.setInt(c, depth);
                    log.fine("Changing undefined level on command " + c.getCommandName() + " to value " + depth);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        fullPath = this.topLevelAgent.getName() + (fullPath.isEmpty() || fullPath.startsWith("/") ? fullPath : "/" + fullPath);
        CompositeCommandSet cmdSet = (CompositeCommandSet)this.commandSetMap.getOrDefault(fullPath, (CommandSet)new CompositeCommandSet());
        cmdSet.add(commandSet);
        this.commandSetMap.put(fullPath, (CommandSet)cmdSet);
    }

    public HashMap<String, Dictionary> getAgentCommandDictionary() {
        return new LinkedHashMap<String, Dictionary>(this.dictionaries);
    }

    private void publishAgentCommandDictionary() {
        log.log(Level.FINER, "Publising CommandDictionary");
        this.topLevelAgent.sendStatusMessage((StatusMessage)new StatusCommandDictionary(this.serializedDictionaries, "gzip"));
    }

    public AgentDictionaryCommand getAgentDictionaryCommand(String destination, final String commandName, final int nArgs) {
        String agentName;
        HashMap<String, Dictionary> dicts = null;
        String string = agentName = destination.contains("/") ? destination.substring(0, destination.indexOf("/")) : destination;
        if (agentName.equals(this.topLevelAgent.getAgentInfo().getName())) {
            dicts = this.dictionaries;
        } else {
            List connectedAgents = this.topLevelAgent.getMessagingAccess().getAgentPresenceManager().listConnectedAgents();
            AgentInfo agentInfo = null;
            for (AgentInfo ai : connectedAgents) {
                if (!ai.getName().equals(agentName)) continue;
                agentInfo = ai;
                break;
            }
            if (agentInfo == null) {
                throw new RuntimeException("Dictionary Command requested for non connected agent " + agentName);
            }
            this.dictionaryUpdateLock.lock();
            try {
                if (!this.agentDictionaries.containsKey(agentInfo)) {
                    Condition c = this.dictionaryWaitConditions.getOrDefault(agentInfo, this.dictionaryUpdateLock.newCondition());
                    this.dictionaryWaitConditions.put(agentInfo, c);
                    if (!c.await(15L, TimeUnit.SECONDS)) {
                        throw new RuntimeException("Could not find dictionary for agent " + agentName);
                    }
                }
                dicts = this.agentDictionaries.get(agentInfo);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Waiting for dictionary interrupted", ie);
            }
            finally {
                this.dictionaryUpdateLock.unlock();
            }
        }
        if (dicts == null) {
            throw new RuntimeException("Could not find dictionary for agent " + agentName);
        }
        Dictionary d = dicts.get(destination);
        if (d == null) {
            throw new RuntimeException("Could not find dictionary for destination " + destination);
        }
        DictionaryCommand command = null;
        try {
            command = d.findCommand(new BasicCommand(){

                public String getCommand() {
                    return commandName;
                }

                public int getArgumentCount() {
                    return nArgs;
                }

                public Object getArgument(int i) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public Object[] getArguments() {
                    return null;
                }

                public Options getOptions() {
                    return new Options();
                }
            });
        }
        catch (CommandArgumentMatchException e) {
            throw new RuntimeException("Could not find command " + commandName + " with " + nArgs + " arguments.");
        }
        return new AgentDictionaryCommand(destination, command, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentCommandDictionaryListener(AgentCommandDictionaryListener listener) {
        ReentrantLock reentrantLock = this.dictionaryUpdateLock;
        synchronized (reentrantLock) {
            for (Map.Entry<AgentInfo, HashMap<String, Dictionary>> entry : this.agentDictionaries.entrySet()) {
                log.log(Level.FINER, "{0} listener joining notification for {1}", new Object[]{listener.getClass().getSimpleName(), entry.getKey().getName()});
                listener.commandDictionaryUpdate(new AgentCommandDictionaryEvent(entry.getKey(), AgentCommandDictionaryEvent.EventType.ADDED, entry.getValue()));
            }
            this.listeners.add(listener);
        }
    }

    public void removeAgentCommandDictionaryListener(AgentCommandDictionaryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAgentCommandDictionaryListeners(AgentCommandDictionaryEvent evt) {
        for (AgentCommandDictionaryListener listener : this.listeners) {
            log.log(Level.FINER, "{0} listener (out of {1}) update notification for {2}: {3}", new Object[]{listener.getClass().getSimpleName(), this.listeners.size(), evt.getAgentInfo().getName(), evt.getEventType()});
            listener.commandDictionaryUpdate(evt);
        }
    }

    private class ClientSideAgentCommandDictionaryBookkeeper
    implements StatusMessageListener,
    AgentPresenceListener,
    AgentLockService.AgentLockUpdateListener {
        private ClientSideAgentCommandDictionaryBookkeeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestAgentCommandDictionaryForOldImplementation(AgentInfo a) {
            ReentrantLock reentrantLock = AgentCommandDictionaryService.this.dictionaryUpdateLock;
            synchronized (reentrantLock) {
                if (!AgentCommandDictionaryService.this.agentDictionaries.containsKey(a) && AgentCommandDictionaryService.this.topLevelAgent.getMessagingAccess().getAgentPresenceManager().agentExists(a.getName())) {
                    log.log(Level.INFO, "{0} Requesting dictionary for {1}.", new Object[]{AgentCommandDictionaryService.this.topLevelAgent.getName(), a});
                    try {
                        CommandRequest publishAgentCommandDictionary = new CommandRequest(a.getName(), "publishAgentCommandDictionary");
                        AgentCommandDictionaryService.this.sci.sendSynchronousCommand(publishAgentCommandDictionary);
                    }
                    catch (Exception e) {
                        RuntimeException re = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                        throw re;
                    }
                }
            }
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo a : agents) {
                AgentCommandDictionaryService.this.topLevelAgent.getScheduler().schedule(() -> this.requestAgentCommandDictionaryForOldImplementation(a), 7L, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected(AgentInfo ... agents) {
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                for (AgentInfo agent : agents) {
                    HashMap dict = (HashMap)AgentCommandDictionaryService.this.agentDictionaries.remove(agent);
                    if (dict == null) continue;
                    log.log(Level.FINER, "Removing dictionary for disconnecting agent {0}", new Object[]{agent.getName()});
                    AgentCommandDictionaryService.this.notifyAgentCommandDictionaryListeners(new AgentCommandDictionaryEvent(agent, AgentCommandDictionaryEvent.EventType.REMOVED, dict));
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        public void onStatusMessage(StatusMessage msg) {
            if (AgentCommandDictionaryService.this.topLevelAgent.getName().equals(msg.getOriginAgentInfo().getName())) {
                return;
            }
            AgentInfo agentInfo = msg.getOriginAgentInfo();
            this.addCommandDictionary(agentInfo, ((StatusCommandDictionary)msg).getDictionary());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCommandDictionary(AgentInfo agent, HashMap<String, Dictionary> dictionary) {
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                if (!AgentCommandDictionaryService.this.agentDictionaries.containsKey(agent)) {
                    Condition c;
                    log.log(Level.FINER, "Received dictionary from {0}", agent.getName());
                    AgentCommandDictionaryService.this.agentDictionaries.put(agent, dictionary);
                    String agentName = agent.getName();
                    AgentLock lock = AgentCommandDictionaryService.this.agentLockService.getLockForAgent(agentName);
                    this.updateLockForDictionary(dictionary, lock);
                    if (lock != null) {
                        int dictionaryLevel = AgentCommandDictionaryService.this.agentLockService.getLevelForAgent(agentName);
                        this.updateLevelForDictionary(dictionary, dictionaryLevel);
                    }
                    if ((c = (Condition)AgentCommandDictionaryService.this.dictionaryWaitConditions.get(agent)) != null) {
                        c.signalAll();
                    }
                    AgentCommandDictionaryService.this.notifyAgentCommandDictionaryListeners(new AgentCommandDictionaryEvent(agent, AgentCommandDictionaryEvent.EventType.ADDED, dictionary));
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        private void updateLevelForDictionary(HashMap<String, Dictionary> dict, int level) {
            for (Dictionary d : dict.values()) {
                d.setLevelForTypes(level, new Command.CommandType[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
            ReentrantLock reentrantLock = AgentCommandDictionaryService.this.dictionaryUpdateLock;
            synchronized (reentrantLock) {
                for (Map.Entry e : AgentCommandDictionaryService.this.agentDictionaries.entrySet()) {
                    if (!((AgentInfo)e.getKey()).getName().equals(agentName)) continue;
                    HashMap dict = (HashMap)e.getValue();
                    this.updateLockForDictionary(dict, lock);
                    log.log(Level.FINER, "Dictionary lock change for {0}", agentName);
                    AgentCommandDictionaryService.this.notifyAgentCommandDictionaryListeners(new AgentCommandDictionaryEvent((AgentInfo)e.getKey(), AgentCommandDictionaryEvent.EventType.UPDATED, dict));
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAgentLevelChange(String agentName, int level) {
            ReentrantLock reentrantLock = AgentCommandDictionaryService.this.dictionaryUpdateLock;
            synchronized (reentrantLock) {
                for (Map.Entry e : AgentCommandDictionaryService.this.agentDictionaries.entrySet()) {
                    if (!((AgentInfo)e.getKey()).getName().equals(agentName)) continue;
                    HashMap dict = (HashMap)e.getValue();
                    this.updateLevelForDictionary(dict, level);
                    log.log(Level.FINER, "Dictionary level change for {0}: new level {1}", new Object[]{agentName, level});
                    AgentCommandDictionaryService.this.notifyAgentCommandDictionaryListeners(new AgentCommandDictionaryEvent((AgentInfo)e.getKey(), AgentCommandDictionaryEvent.EventType.UPDATED, dict));
                    return;
                }
            }
        }

        private void updateLockForDictionary(HashMap<String, Dictionary> dict, AgentLock lock) {
            if (lock != null) {
                for (Dictionary d : dict.values()) {
                    d.setLevelForTypes(0, new Command.CommandType[0]);
                }
            } else {
                for (Dictionary d : dict.values()) {
                    d.setLevelForTypes(-1, new Command.CommandType[0]);
                    d.setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
                }
            }
        }
    }

    private class AgentPublishDictionaryStrategy
    implements AgentPresenceListener {
        private AgentPublishDictionaryStrategy() {
        }

        public void connected(AgentInfo ... agents) {
            this.publishOnConnectingAgents(agents);
        }

        private void publishOnConnectingAgents(AgentInfo ... agents) {
            for (AgentInfo a : agents) {
                if (AgentCommandDictionaryService.doesAgentNeedDictionary(a)) {
                    log.log(Level.FINER, "Spontaneous publication for agent {0}", new Object[]{a.getName()});
                    AgentCommandDictionaryService.this.publishAgentCommandDictionary();
                    return;
                }
                log.log(Level.FINER, "No dictionary publication for agent {0}", new Object[]{a.getName()});
            }
        }
    }

    public class AgentCommandDictionaryCommands {
        @Command(description="Get the agent's command dictionary", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public HashMap<String, Dictionary> getDictionaries() {
            return AgentCommandDictionaryService.this.getAgentCommandDictionary();
        }

        @Command(description="Get the list of command targets", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public List<String> getCommandTargets() {
            return new ArrayList<String>(AgentCommandDictionaryService.this.commandTargets);
        }

        @Command(description="Publish the agent's command dictionary on the status bus", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishAgentCommandDictionary() {
            log.log(Level.FINER, "Received request to publish the command dictionary");
            AgentCommandDictionaryService.this.publishAgentCommandDictionary();
        }
    }

    public static class AgentCommandDictionaryEvent {
        private final EventType eventType;
        private final AgentInfo agentInfo;
        private final HashMap<String, Dictionary> dictionary;

        AgentCommandDictionaryEvent(AgentInfo agentInfo, EventType eventType, HashMap<String, Dictionary> dictionary) {
            this.eventType = eventType;
            this.agentInfo = agentInfo;
            this.dictionary = dictionary;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public AgentInfo getAgentInfo() {
            return this.agentInfo;
        }

        public HashMap<String, Dictionary> getDictionary() {
            return this.dictionary;
        }

        public static enum EventType {
            ADDED,
            UPDATED,
            REMOVED;

        }
    }

    public static interface AgentCommandDictionaryListener {
        public void commandDictionaryUpdate(AgentCommandDictionaryEvent var1);
    }
}

