/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterManager;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.plugin.tree.FTreeNodeStructureProvider;
import org.freehep.jas.plugin.tree.FTreeNodeTextChangeEvent;
import org.freehep.jas.plugin.tree.FTreeNodeTransferable;
import org.freehep.jas.plugin.tree.FTreeSelectionEvent;
import org.freehep.util.commanddispatcher.CommandProcessor;

class DefaultFTreeNodeAdapterWrapper
implements FTreeNodeAdapter {
    private Class clazz;
    private List result = null;
    private FTreeNodeObjectProvider objectProvider;
    private DefaultFTreeNodeAdapterManager adapterManager;

    DefaultFTreeNodeAdapterWrapper(Class clazz, DefaultFTreeNodeAdapterManager adapterManager) {
        this.clazz = clazz;
        this.objectProvider = new ObjectProvider(this);
        this.adapterManager = adapterManager;
    }

    List result() {
        this.result = this.adapterManager.lookup().getFTreeNodeAdaptersForClass(this.clazz);
        return this.result;
    }

    @Override
    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            if (menu == null) {
                menu = new JPopupMenu();
            }
            menu = adapter.modifyPopupMenu(nodes, menu);
        }
        return menu;
    }

    @Override
    public FTreeNodeObjectProvider treeNodeObjectProvider(FTreeNode node) {
        return this.objectProvider;
    }

    @Override
    public void checkForChildren(FTreeNode node) {
        Object obj = node.value("wrapperChildrenChecked");
        if (obj == null) {
            for (FTreeNodeAdapter adapter : this.result()) {
                adapter.checkForChildren(node);
            }
            node.addKey("wrapperChildrenChecked", new Boolean(true));
        }
    }

    @Override
    public boolean allowsChildren(FTreeNode node, boolean allowsChildren) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            allowsChildren = adapter.allowsChildren(node, allowsChildren);
        }
        return allowsChildren;
    }

    @Override
    public FTreeNodeTransferable modifyTransferable(FTreeNode[] nodes, FTreeNodeTransferable transferable) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            transferable = adapter.modifyTransferable(nodes, transferable);
        }
        return transferable;
    }

    @Override
    public boolean doubleClick(FTreeNode node) {
        for (FTreeNodeAdapter adapter : this.result()) {
            if (!adapter.doubleClick(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(FTreeNode node, MouseEvent mouseEvent, Dimension dimension) {
        for (FTreeNodeAdapter adapter : this.result()) {
            if (!adapter.mouseClicked(node, mouseEvent, dimension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String statusMessage(FTreeNode node, String message) {
        String originalMessage = message;
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            if (message == null) {
                message = originalMessage;
            }
            message = adapter.statusMessage(node, message);
        }
        return message;
    }

    @Override
    public String toolTipMessage(FTreeNode node, String message) {
        String originalMessage = message;
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            if (message == null) {
                message = originalMessage;
            }
            message = adapter.toolTipMessage(node, message);
        }
        return message;
    }

    @Override
    public String text(FTreeNode node, String text) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            text = adapter.text(node, text);
        }
        return text;
    }

    @Override
    public Icon icon(FTreeNode node, Icon defaultIcon, boolean selected, boolean expanded) {
        Icon icon = defaultIcon;
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            if (icon == null) {
                icon = defaultIcon;
            }
            icon = adapter.icon(node, icon, selected, expanded);
        }
        return icon;
    }

    @Override
    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        for (FTreeNodeAdapter adapter : this.result()) {
            CommandProcessor cp = adapter.commandProcessor(selectedNodes);
            if (cp == null) continue;
            return cp;
        }
        return null;
    }

    @Override
    public boolean selectionChanged(FTreeSelectionEvent e) {
        boolean foundAdapter = false;
        for (FTreeNodeAdapter adapter : this.result()) {
            if (!adapter.selectionChanged(e)) continue;
            foundAdapter = true;
            break;
        }
        return foundAdapter;
    }

    @Override
    public void nodeBeingDeleted(FTreeNode node) {
        for (FTreeNodeAdapter adapter : this.result()) {
            adapter.nodeBeingDeleted(node);
        }
    }

    @Override
    public boolean canTextBeChanged(FTreeNodeTextChangeEvent evt, boolean isEditable) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            isEditable = adapter.canTextBeChanged(evt, isEditable);
        }
        return isEditable;
    }

    @Override
    public boolean acceptNewText(FTreeNodeTextChangeEvent evt, boolean acceptNewText) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            acceptNewText = adapter.acceptNewText(evt, acceptNewText);
        }
        return acceptNewText;
    }

    @Override
    public void nodeTextChanged(FTreeNodeTextChangeEvent evt) {
        for (FTreeNodeAdapter adapter : this.result()) {
            adapter.nodeTextChanged(evt);
            if (!evt.isConsumed()) continue;
            break;
        }
    }

    @Override
    public Component treeCellRendererComponent(Component component, FTreeNode node, boolean sel, boolean expanded, boolean leaf, boolean hasFocus) {
        ListIterator i = this.result().listIterator(this.result().size());
        while (i.hasPrevious()) {
            FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.previous();
            component = adapter.treeCellRendererComponent(component, node, sel, expanded, leaf, hasFocus);
        }
        return component;
    }

    @Override
    public int priority(FTree tree) {
        Iterator i = this.result().iterator();
        FTreeNodeAdapter adapter = (FTreeNodeAdapter)i.next();
        return adapter.priority(tree);
    }

    @Override
    public FTreeNodeStructureProvider nodeStructureProvider(FTreeNode node) {
        for (FTreeNodeAdapter adapter : this.result()) {
            FTreeNodeStructureProvider structureProvider = adapter.nodeStructureProvider(node);
            if (structureProvider == null) continue;
            return structureProvider;
        }
        throw new RuntimeException("No structure provider available!! Please report this problem.");
    }

    private class ObjectProvider
    implements FTreeNodeObjectProvider {
        private DefaultFTreeNodeAdapterWrapper adapter;

        ObjectProvider(DefaultFTreeNodeAdapterWrapper adapter) {
            this.adapter = adapter;
        }

        @Override
        public Object objectForNode(FTreeNode node, Class clazz) {
            for (FTreeNodeAdapter adapter : this.adapter.result()) {
                Object object;
                FTreeNodeObjectProvider provider = adapter.treeNodeObjectProvider(node);
                if (provider == null || (object = provider.objectForNode(node, clazz)) == null || !clazz.isAssignableFrom(object.getClass())) continue;
                return object;
            }
            return null;
        }
    }
}

