/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DefaultDataManager;
import jas.hist.JASHistAxis;
import jas.plot.Axis;
import jas.plot.AxisType;
import jas.plot.DateAxis;
import jas.plot.DoubleAxis;
import jas.plot.EditableLabel;
import jas.plot.StringAxis;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class ManagedAxis
extends Axis
implements JASHistAxis,
Externalizable {
    private int bins;
    private boolean rangeAutomatic = true;
    private boolean allowSuppressedZero = true;
    private boolean showOverflows = false;
    private boolean needsAttention = true;
    private boolean fixed = false;
    private boolean binned;
    private int position;
    private DataManager dataManager;

    ManagedAxis(int orientation) {
        super(orientation);
        this.dataManager = null;
        this.binned = false;
    }

    ManagedAxis(DataManager dm, int orientation, boolean binned) {
        super(orientation);
        this.dataManager = dm;
        this.binned = binned;
    }

    public ManagedAxis() {
    }

    void setDataManager(DataManager dm, boolean binned) {
        this.dataManager = dm;
        this.binned = binned;
    }

    void setDataManager(DataManager dm, boolean binned, AxisType t) {
        this.dataManager = dm;
        this.binned = binned;
        this.setType(t);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.bins);
        out.writeBoolean(this.rangeAutomatic);
        if (!this.rangeAutomatic) {
            out.writeDouble(this.getMin());
            out.writeDouble(this.getMax());
        }
        out.writeBoolean(this.allowSuppressedZero);
        out.writeBoolean(this.fixed);
        out.writeBoolean(this.binned);
        out.writeInt(this.position);
        AxisType type = this.getType();
        out.writeInt(this.getAxisOrientation());
        out.writeBoolean(this.getOnLeftSide());
        out.writeObject(type);
        out.writeObject(this.dataManager);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bins = in.readInt();
        this.rangeAutomatic = in.readBoolean();
        if (!this.rangeAutomatic) {
            this.setMin(in.readDouble());
            this.setMax(in.readDouble());
        } else {
            this.attentionNeeded();
        }
        this.allowSuppressedZero = in.readBoolean();
        this.fixed = in.readBoolean();
        this.binned = in.readBoolean();
        this.position = in.readInt();
        this.setAxisOrientation(in.readInt());
        this.setOnLeftSide(in.readBoolean());
        this.setType((AxisType)in.readObject());
        this.dataManager = (DataManager)in.readObject();
    }

    @Override
    public boolean isVertical() {
        return this.getAxisOrientation() == 1;
    }

    @Override
    public boolean isLogarithmic() {
        AxisType type = this.getType();
        if (type instanceof DoubleAxis) {
            return ((DoubleAxis)type).isLogarithmic();
        }
        return false;
    }

    @Override
    public void setLogarithmic(boolean value) {
        AxisType type = this.getType();
        if (type instanceof DoubleAxis) {
            ((DoubleAxis)type).setLogarithmic(value);
            this.attentionNeeded();
        }
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    @Override
    public void setShowing(boolean value) {
    }

    @Override
    public EditableLabel getLabelObject() {
        if (this.dataManager == null) {
            return null;
        }
        EditableLabel label = this.dataManager.getLabel(this);
        if (label == null) {
            return null;
        }
        return label;
    }

    @Override
    public String getLabel() {
        EditableLabel label = this.dataManager.getLabel(this);
        return label == null ? "" : label.getText();
    }

    @Override
    public void setLabelObject(EditableLabel p_newLabel) {
        this.dataManager.setLabel(this, p_newLabel);
    }

    @Override
    public void setLabel(String s) {
        EditableLabel label = this.dataManager.getLabel(this);
        if (label == null) {
            label = new EditableLabel(s, "Axis Label", 2);
            this.dataManager.setLabel(this, label);
        } else {
            label.setText(s);
        }
        this.revalidate();
    }

    @Override
    public double getMin() {
        AxisType type = this.getType();
        if (type instanceof DoubleAxis) {
            return ((DoubleAxis)type).getPlotMin();
        }
        if (type instanceof DateAxis) {
            return (double)((DateAxis)type).getAxisMin() / 1000.0;
        }
        throw new RuntimeException("getMin undefined for this axis type");
    }

    @Override
    public void setMin(double d) {
        AxisType type = this.getType();
        if (type instanceof DoubleAxis) {
            this.rangeAutomatic = false;
            ((DoubleAxis)type).setMin(d);
            this.attentionNeeded();
        } else if (type instanceof DateAxis) {
            this.rangeAutomatic = false;
            ((DateAxis)type).setMin((long)(d * 1000.0));
            this.attentionNeeded();
        } else {
            throw new RuntimeException("setMin undefined for this axis type");
        }
    }

    @Override
    public double getMax() {
        AxisType type = this.getType();
        if (type instanceof DoubleAxis) {
            return ((DoubleAxis)type).getPlotMax();
        }
        if (type instanceof DateAxis) {
            return (double)((DateAxis)type).getAxisMax() / 1000.0;
        }
        throw new RuntimeException("getMax undefined for this axis type");
    }

    @Override
    public void setMax(double d) {
        AxisType type = this.getType();
        if (type instanceof DoubleAxis) {
            this.rangeAutomatic = false;
            ((DoubleAxis)type).setMax(d);
            this.attentionNeeded();
        } else if (type instanceof DateAxis) {
            this.rangeAutomatic = false;
            ((DateAxis)type).setMax((long)(d * 1000.0));
            this.invalidate();
            this.attentionNeeded();
        } else {
            throw new RuntimeException("setMax undefined for this axis type");
        }
    }

    @Override
    public void setRange(double min, double max) {
        this.setMin(min);
        this.setMax(max);
    }

    @Override
    public Object getMinObject() {
        if (this.getAxisType() == 3) {
            return new Date((long)(this.getMin() * 1000.0));
        }
        return new Double(this.getMin());
    }

    @Override
    public Object getMaxObject() {
        if (this.getAxisType() == 3) {
            return new Date((long)(this.getMax() * 1000.0));
        }
        return new Double(this.getMax());
    }

    @Override
    public void setMinObject(Object value) {
        try {
            double min = this.getAxisType() == 3 ? (double)(((Date)value).getTime() / 1000L) : (Double)value;
            this.setMin(min);
        }
        catch (ClassCastException x) {
            throw new IllegalArgumentException("Argument to setMinObject is of wrong type");
        }
    }

    @Override
    public void setMaxObject(Object value) {
        try {
            double max = this.getAxisType() == 3 ? (double)(((Date)value).getTime() / 1000L) : (Double)value;
            this.setMax(max);
        }
        catch (ClassCastException x) {
            throw new IllegalArgumentException("Argument to setMaxObject is of wrong type");
        }
    }

    @Override
    public boolean getRangeAutomatic() {
        return this.rangeAutomatic;
    }

    @Override
    public void setRangeAutomatic(boolean b) {
        this.rangeAutomatic = b;
        this.attentionNeeded();
    }

    @Override
    public boolean getAllowSuppressedZero() {
        return this.allowSuppressedZero;
    }

    @Override
    public void setAllowSuppressedZero(boolean b) {
        this.allowSuppressedZero = b;
        this.attentionNeeded();
    }

    @Override
    public boolean isBinned() {
        return this.binned;
    }

    public void setBinned(boolean value) {
        this.binned = value;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean value) {
        this.fixed = value;
    }

    @Override
    public int getBins() {
        return this.bins;
    }

    @Override
    public void setBins(int value) {
        this.bins = value;
        this.attentionNeeded();
    }

    @Override
    public double getBinWidth() {
        if (!this.binned) {
            return 0.0;
        }
        double range = this.getMax() - this.getMin();
        return range / (double)this.bins;
    }

    @Override
    public void setBinWidth(double value) {
        double range = this.getMax() - this.getMin();
        this.bins = (int)Math.max(1.0, range / value);
        this.attentionNeeded();
    }

    @Override
    public boolean getShowOverflows() {
        return this.showOverflows;
    }

    @Override
    public void setShowOverflows(boolean value) {
        this.showOverflows = value;
        this.attentionNeeded();
    }

    @Override
    public int getLabelPosition() {
        return 0;
    }

    @Override
    public void setLabelPosition(int pos) {
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int value) {
        this.position = value;
    }

    @Override
    public int getAxisType() {
        AxisType type = this.getType();
        if (type instanceof DateAxis) {
            return 3;
        }
        if (type instanceof StringAxis) {
            return 2;
        }
        return 1;
    }

    @Override
    public void setAxisType(int value) {
        if (value != this.getAxisType()) {
            if (value == 3) {
                this.setType(new DateAxis());
            } else if (value == 2) {
                this.setType(new StringAxis());
            } else {
                this.setType(new DoubleAxis());
            }
        }
    }

    private void attentionNeeded() {
        boolean requestedAttention = this.needsAttention;
        this.needsAttention = true;
        if (!requestedAttention && this.dataManager != null) {
            this.dataManager.invalidate();
        }
    }

    void setAttentionNeeded() {
        this.needsAttention = true;
    }

    void payingAttention() {
        this.needsAttention = false;
    }

    boolean needsAttention() {
        return this.needsAttention;
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (this.dataManager != null && !(this.dataManager instanceof DefaultDataManager)) {
            super.modifyPopupMenu(menu, source);
            if (this.getAxisType() != 2) {
                if (this.getAxisType() != 3) {
                    menu.add(new JCheckBoxMenuItem("Logarithmic", this.isLogarithmic()){

                        @Override
                        protected final void fireActionPerformed(ActionEvent e) {
                            ManagedAxis.this.setLogarithmic(this.isSelected());
                        }
                    });
                }
                menu.add(new JCheckBoxMenuItem("Range Automatic", this.getRangeAutomatic()){

                    @Override
                    protected final void fireActionPerformed(ActionEvent e) {
                        ManagedAxis.this.setRangeAutomatic(this.isSelected());
                    }
                });
                if (this.getAxisType() != 3) {
                    JCheckBoxMenuItem suppZero = new JCheckBoxMenuItem("Suppressed Zeros", this.getAllowSuppressedZero()){

                        @Override
                        protected final void fireActionPerformed(ActionEvent e) {
                            ManagedAxis.this.setAllowSuppressedZero(this.isSelected());
                        }
                    };
                    menu.add(suppZero);
                    suppZero.setEnabled(this.getRangeAutomatic());
                }
            }
            menu.add(new JMenuItem("Axis Properties..."){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    ManagedAxis.this.dataManager.getPlot().showProperties((byte)(ManagedAxis.this.getAxisOrientation() == 1 ? (ManagedAxis.this.getOnLeftSide() ? 1 : 2) : 3));
                }
            });
        }
    }
}

