/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.services.alert.AlertService;

public class AlertRaisingAlarm
extends Alarm {
    private static final Logger LOG = Logger.getLogger(AlertRaisingAlarm.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private Alert alertToBeRaised;

    public AlertRaisingAlarm() {
        this(null);
    }

    public AlertRaisingAlarm(Alert alert) {
        this.alertToBeRaised = alert;
    }

    @Override
    public void build() {
        if (this.alertService == null) {
            throw new RuntimeException("AlertRaisingAlarm instances must be part of the agent object tree. The AlertService instance must be non null.");
        }
        super.build();
    }

    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        if (this.alertToBeRaised == null) {
            throw new RuntimeException("No Alert to be raised was defined for this AlertRaisingAlarm. Either provide one in the constructor or overwrite method AlertRaisingAlarm::getAlert(AlertState,AlertState).");
        }
        return this.alertToBeRaised;
    }

    @Override
    protected Alert getAlert() {
        return this.getAlert(AlertState.NOMINAL, AlertState.NOMINAL);
    }

    @Override
    void processAlarmTrigger(String alarmCause) {
        AlertState oldAlertState;
        AlertState alertState = AlertRaisingAlarm.getAlertState(this.getAlarmState());
        Alert alert = this.getAlert(alertState, oldAlertState = AlertRaisingAlarm.getAlertState(this.getAlarmPreviousState()));
        if (alert != null) {
            LOG.log(AlertRaisingAlarm.getLogLevel(this.getAlarmState()), "Processing \"{0}\" at level {1}.\nRaising Alert {2} with AlertState {3} caused by {4}.", new Object[]{alert.getDescription(), this.getAlarmState(), alert.getAlertId(), alertState, alarmCause});
            this.alertService.raiseAlert(alert, alertState, alarmCause);
        } else {
            LOG.log(Level.WARNING, "Null Alert provided, so no Alert is raised.");
        }
    }

    private static AlertState getAlertState(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return AlertState.ALARM;
            }
            case WARNING: {
                return AlertState.WARNING;
            }
            case NOMINAL: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an AlertState");
    }

    private static Level getLogLevel(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case NOMINAL: {
                return Level.INFO;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an log Level");
    }
}

