/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.test.AidaTestCase;
import junit.framework.Assert;

public class TestAxis
extends AidaTestCase {
    public TestAxis(String testName) {
        super(testName);
    }

    public void testFixedBinAxis() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(tree);
        IHistogram1D h1 = histogramFactory.createHistogram1D("h1", 50, -100.0, 100.0);
        IAxis axis = h1.axis();
        Assert.assertTrue((boolean)axis.isFixedBinning());
        AidaTestCase.assertEqualsDouble(axis.lowerEdge(), -100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.upperEdge(), 100.0, 0.0);
        Assert.assertEquals((int)axis.bins(), (int)50);
        AidaTestCase.assertEqualsDouble(axis.binLowerEdge(0), -100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binUpperEdge(0), -96.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binLowerEdge(-2), Double.NEGATIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binUpperEdge(-2), -100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binLowerEdge(-1), 100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binUpperEdge(-1), Double.POSITIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binWidth(6), 4.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binWidth(-2), Double.POSITIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binWidth(-1), Double.POSITIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binCenter(3), -86.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binCenter(-2), Double.NEGATIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binCenter(-1), Double.POSITIVE_INFINITY, 0.0);
        Assert.assertEquals((int)axis.coordToIndex(-456.0), (int)-2);
        Assert.assertEquals((int)axis.coordToIndex(100.0001), (int)-1);
        Assert.assertEquals((int)axis.coordToIndex(86.78), (int)46);
    }

    public void testVariableBinAxis() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(tree);
        double[] edges = new double[]{-100.0, -23.0, 0.0, 2.0, 4.0, 5.0, 78.0, 100.0};
        IHistogram1D h1 = histogramFactory.createHistogram1D("h1", "h1", edges);
        IAxis axis = h1.axis();
        Assert.assertTrue((!axis.isFixedBinning() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(axis.lowerEdge(), -100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.upperEdge(), 100.0, 0.0);
        Assert.assertEquals((int)axis.bins(), (int)7);
        AidaTestCase.assertEqualsDouble(axis.binLowerEdge(0), -100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binUpperEdge(0), -23.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binLowerEdge(-2), Double.NEGATIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binUpperEdge(-2), -100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binLowerEdge(-1), 100.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binUpperEdge(-1), Double.POSITIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binWidth(6), 22.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binWidth(-2), Double.POSITIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binWidth(-1), Double.POSITIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binCenter(3), 3.0, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binCenter(-2), Double.NEGATIVE_INFINITY, 0.0);
        AidaTestCase.assertEqualsDouble(axis.binCenter(-1), Double.POSITIVE_INFINITY, 0.0);
        Assert.assertEquals((int)axis.coordToIndex(-456.0), (int)-2);
        Assert.assertEquals((int)axis.coordToIndex(100.0001), (int)-1);
        Assert.assertEquals((int)axis.coordToIndex(86.78), (int)6);
    }
}

