/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nom.tam.fits.FitsException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystem.archon.RawImageConverter;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.HeaderSpecification;

class ImageHandler {
    private final Map<String, HeaderSpecification> imageWriterConfig = new HashMap<String, HeaderSpecification>();

    ImageHandler() {
        this.readHeaderSpecification("primary");
        this.readHeaderSpecification("extended");
        this.readHeaderSpecification("test_cond");
        this.readHeaderSpecification("ccd_cond");
        this.readHeaderSpecification("photodiode_cond");
        this.readHeaderSpecification("photodiode2_cond");
    }

    Map<String, HeaderSpecification> getConfig() {
        return Collections.unmodifiableMap(this.imageWriterConfig);
    }

    private void readHeaderSpecification(String name) throws RuntimeException {
        String fileName = name + ".spec";
        try (InputStream bootstrapResource = BootstrapResourceUtils.getBootstrapResource((String)fileName);){
            if (bootstrapResource == null) {
                throw new RuntimeException("Failed to open bootstrap resource: " + fileName);
            }
            HeaderSpecification desc = new HeaderSpecification(name, bootstrapResource);
            this.imageWriterConfig.put(name, desc);
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading " + fileName, x);
        }
    }

    void writeImage(File file, RawImageConverter imageConverter, Map<String, Map<String, Object>> metaDataMap) throws IOException, FitsException {
        try (FitsFileWriter writer = new FitsFileWriter(file, imageConverter.getImageSet(), metaDataMap, this.imageWriterConfig, FitsFileWriter.BitsPerPixel.BIT16);){
            imageConverter.pushDataToFile(writer);
        }
    }
}

