package org.lsst.ccs.subsystem.airwatch.main;

/**
 * Static functions other things without their own classes.
 * @author tether
 */
public class Utility {
    
    private Utility() {}
    
    private final static double ARDEN_B = 17.368; // dimensionless
    
    private final static double ARDEN_C = 238.88; // degrees C
    
    private final static double ARDEN_D = 234.5; // degrees C

    /**
     * Calculates the dew point temperature from current conditions. Uses the
     * extended Magnus formula from the Wikipedia article on dew point, with the
     * constants chose by Arden Buck for ambient T between 0 and 50 deg C.
     * @param temp the ambient air temperature in degrees Celsius. SHould be be between
     * 0 and 50 degrees, inclusive.
     * @param rh the relative humidity expressed as a percentage.
     * @return The dew point temperature in degrees Celsius. Maximum error 0.05%.
     */
    public static double dewPoint(final double temp, final double rh) {
        final double gamma = 
            Math.log((rh/100.0)
                    * Math.exp((ARDEN_B - temp/ARDEN_D) * (temp / (ARDEN_C + temp))
                    )
            );
        return ARDEN_C * gamma / (ARDEN_B - gamma);
    }
}
