package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;

/**
 * Contains all the data for one reading of one particle counter channel.
 * @author tether
 */
public class CounterPoint implements Serializable {
    private static final long serialVersionUID = 1_0_3;
    
    /** The absolute number of particles detected in the air sample. */
    public final Double  absolute;

    /** The particle density (particles/volume). */
    public final Double  density;
    
    /** Non-zero if the density was over the limit set for the channel. */
    public final Integer limitViolation;
    
    /** Non-zero if the channel experienced a malfunction during measurement. */
    public final Integer malfunction;

    public CounterPoint(
        final Double absolute,
        final Double density,
        final Boolean viol,
        final Boolean malf)
    {
        this.absolute = absolute;
        this.density = density;
        // At the time this was written, boolean values could not go into the trending DB.
        this.limitViolation = viol ? 1 : 0;
        this.malfunction = malf ? 1 : 0;
    }
    @Override
    public String toString() {
        return String.format(
            "[absolute: %s, density: %s,limitViolation: %s, malfunction: %s]",
            absolute, density, limitViolation, malfunction);
    }
    }
