package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;

/**
 * Contains all the values for one reading of one analog channel such as temperature or humidity.
 * @author tether
 */

public class AnalogPoint implements Serializable {
    private static final long serialVersionUID = 1_0_3;
    
    /** The value read from the channel. */
    public final Double  value;
    
    /** Non-zero if the sensor value is outside the bounds set for the channel. */
    public final Integer limitViolation;
    
    /** Non-zero if there was a malfunction during measurement. */
    public final Integer malfunction;

    public AnalogPoint(
        final Double value,
        final Boolean viol,
        final Boolean malf)
    {
        this.value = value;
        // At the time this was written, boolean values could not go into the trending DB.
        this.limitViolation = viol ? 1 : 0;
        this.malfunction = malf ? 1 : 0;
    }
    @Override
    public String toString() {
        return String.format(
            "[value: %s, limitViolation: %s, malfunction: %s]",
            value, limitViolation, malfunction);
    }
}
