/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.InternalFramePageManager;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.application.mdi.ToolBarHolder;
import org.freehep.application.studio.Plugin;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;

public class MDIApplication
extends Application {
    public static final int TOOLBAR_DEFAULT = 0;
    public static final int TOOLBAR_INVISIBLE = 1;
    public static final int TOOLBAR_VISIBLE = 2;
    public static final int TOOLBAR_AUTO = 3;
    public static final int TOOLBAR_PROGRAM = 4;
    private PageListener pageListener = new MDIPageListener();
    private PageManager pageManager;
    private PageManager controlManager;
    private PageManager consoleManager;
    private JSplitPane consoleSplit;
    private JSplitPane controlSplit;
    private ToolBarHolder mdiToolBarHolder;
    private PageManager selectedPageManager;

    public MDIApplication(String appName) {
        super(appName);
        this.add(this.getPageManager().getEmbodiment());
    }

    @Override
    protected void loadDefaultProperties(Properties app) throws IOException {
        super.loadDefaultProperties(app);
        InputStream in = MDIApplication.class.getResourceAsStream("MDIDefault.properties");
        app.load(in);
        in.close();
    }

    @Override
    protected void saveUserProperties() {
        Properties user = this.getUserProperties();
        if (this.consoleSplit != null) {
            PropertyUtilities.setInteger(user, "consoleSize", this.consoleSplit.getHeight() - this.consoleSplit.getDividerLocation());
        }
        if (this.controlSplit != null) {
            PropertyUtilities.setInteger(user, "controlSize", this.controlSplit.getDividerLocation());
        }
        if (this.mdiToolBarHolder != null) {
            this.mdiToolBarHolder.save(user);
        }
        super.saveUserProperties();
    }

    public void addToolBar(JToolBar toolBar, String name, int mode) {
        if (this.mdiToolBarHolder == null) {
            this.mdiToolBarHolder = new ToolBarHolder();
            this.getToolBarHolder().add((Component)this.mdiToolBarHolder, "North");
        }
        if (mode == 0) {
            mode = PropertyUtilities.getInteger(this.getUserProperties(), "ToolBar." + name, mode);
        }
        this.mdiToolBarHolder.add(toolBar, name, mode);
    }

    public void addToolBar(JToolBar toolBar, String name) {
        this.addToolBar(toolBar, name, 0);
    }

    public void removeToolBar(JToolBar toolBar) {
        this.mdiToolBarHolder.remove(toolBar);
    }

    public void addMenu(JMenuItem item, long location) {
        JMenuBar bar = this.getMenuBar();
        String loc = String.valueOf(location);
        MDIApplication.addMenu(bar, loc, item);
    }

    private static void addMenu(Container parent, String loc, JMenuItem item) {
        int l = loc.length() % 3;
        if (l == 0) {
            l = 3;
        }
        int ll = Integer.parseInt(loc.substring(0, l));
        Component[] c = parent instanceof JMenu ? ((JMenu)parent).getPopupMenu().getComponents() : parent.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JComponent child;
            Object location;
            Component comp = c[i];
            if (!(comp instanceof JComponent) || !((location = (child = (JComponent)comp).getClientProperty("Location")) instanceof Integer)) continue;
            int locat = (Integer)location;
            if (locat == ll) {
                String remainder = loc.substring(l);
                if (remainder.length() > 0 && child instanceof Container) {
                    MDIApplication.addMenu((Container)comp, remainder, item);
                    return;
                }
                throw new RuntimeException("Invalid location for addMenu");
            }
            if (locat <= ll) continue;
            parent.add((Component)item, i);
            item.putClientProperty("Location", ll);
            return;
        }
        parent.add(item);
        item.putClientProperty("Location", ll);
    }

    public void addMenu(Action action, String plugin, String ... locations) {
        int i;
        if (locations.length == 0) {
            throw new IllegalArgumentException("At least top level menu should be specified.");
        }
        JMenuBar bar = this.getMenuBar();
        int pos = locations[0].indexOf(58);
        if (pos != -1) {
            String s = locations[0].substring(0, pos);
            try {
                i = Integer.parseInt(s);
                locations[0] = locations[0].substring(pos + 1);
                pos = i;
            }
            catch (IndexOutOfBoundsException | NumberFormatException x) {
                pos = -1;
            }
        }
        Location[] locs = new Location[locations.length];
        block11: for (i = 0; i < locs.length; ++i) {
            Location loc;
            String[] tokens = locations[i].split(":");
            locs[i] = loc = new Location();
            loc.name = tokens[0];
            switch (tokens.length) {
                case 1: {
                    loc.group = 0;
                    loc.position = 0;
                    continue block11;
                }
                case 2: {
                    loc.group = 0;
                    loc.position = Integer.parseInt(tokens[1]);
                    continue block11;
                }
                case 3: {
                    loc.group = Integer.parseInt(tokens[1]);
                    loc.position = Integer.parseInt(tokens[2]);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Illegal location string: " + locations[i]);
                }
            }
        }
        JMenu menu = null;
        try {
            menu = (JMenu)MDIApplication.findMenu(bar, locs[0].name);
        }
        catch (ClassCastException tokens) {
            // empty catch block
        }
        if (menu == null) {
            menu = new JMenu(locs[0].name);
            if (pos == -1) {
                bar.add(menu);
            } else {
                menu.putClientProperty("Location", pos);
                Component[] cc = bar.getComponents();
                boolean notDone = true;
                for (int i2 = 0; i2 < cc.length; ++i2) {
                    try {
                        int itemPos;
                        JMenu item = (JMenu)cc[i2];
                        Object o = item.getClientProperty("Location");
                        int n = itemPos = o == null ? 0 : (Integer)o;
                        if (itemPos <= pos) continue;
                        bar.add((Component)menu, i2);
                        notDone = false;
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (notDone) {
                    bar.add(menu);
                }
            }
        }
        MDIApplication.addMenu(action, plugin, menu, locs, 1);
    }

    private static void addMenu(Action action, String plugin, JMenu parent, Location[] locations, int level) {
        boolean finalLevel = level == locations.length;
        String name = finalLevel ? action.toString() : locations[level].name;
        JMenuItem levelItem = MDIApplication.findMenu(parent, name);
        Location loc = locations[level - 1];
        if (levelItem == null) {
            if (finalLevel) {
                levelItem = action.getValue("SwingSelectedKey") == null ? new JMenuItem(action) : new JCheckBoxMenuItem(action);
            } else {
                levelItem = new JMenu(name);
                MDIApplication.addMenu(action, plugin, (JMenu)levelItem, locations, level + 1);
            }
            levelItem.putClientProperty("Location", loc.position);
            levelItem.putClientProperty(Plugin.GROUP_PROPERTY, loc.group);
            levelItem.putClientProperty(Plugin.PLUGIN_PROPERTY, plugin);
            MDIApplication.positionMenu(parent, levelItem, plugin, loc.group, loc.position);
        } else {
            if (finalLevel) {
                throw new IllegalArgumentException("Duplicate menu item: " + name);
            }
            MDIApplication.addMenu(action, plugin, (JMenu)levelItem, locations, level + 1);
        }
    }

    private static JMenuItem findMenu(JComponent parent, String name) {
        Component[] components;
        for (Component e : components = parent instanceof JMenu ? ((JMenu)parent).getPopupMenu().getComponents() : parent.getComponents()) {
            try {
                JMenuItem menu = (JMenuItem)e;
                if (!name.equals(menu.getText())) continue;
                return menu;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void positionMenu(JMenu parent, JMenuItem child, String plugin, int group, int position) {
        int pos = 0;
        int gr = 0;
        String plug = null;
        int index = -1;
        Component[] components = parent.getMenuComponents();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            try {
                JMenuItem item = (JMenuItem)components[i];
                Object o = item.getClientProperty("Location");
                int itemPos = o == null ? 0 : (Integer)o;
                o = item.getClientProperty(Plugin.GROUP_PROPERTY);
                int itemGroup = o == null ? 0 : (Integer)o;
                String itemPlug = (String)item.getClientProperty(Plugin.PLUGIN_PROPERTY);
                if (Math.abs(itemGroup) > Math.abs(group) || itemGroup == group && (itemGroup <= 0 || plugin.equals(itemPlug)) && itemPos > position) {
                    if (index == -1) {
                        parent.insert(child, 0);
                        if (itemGroup == group) break;
                        parent.insertSeparator(1);
                        break;
                    }
                    if (itemGroup == group) {
                        parent.insert(child, i);
                        break;
                    }
                    if (gr == group) {
                        parent.insert(child, index + 1);
                        break;
                    }
                    parent.insert(child, i);
                    parent.insertSeparator(i + 1);
                    break;
                }
                pos = itemPos;
                gr = itemGroup;
                plug = itemPlug;
                index = i;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (index == n - 1) {
            if (n == 0 || gr == group && (gr <= 0 || plugin.equals(plug))) {
                parent.add(child);
            } else {
                parent.addSeparator();
                parent.add(child);
            }
        }
    }

    public boolean removeMenu(String ... locations) {
        JMenu menu;
        int n = locations.length;
        if (n == 0) {
            return false;
        }
        ArrayDeque<JComponent> menus = new ArrayDeque<JComponent>();
        menus.add(this.getMenuBar());
        for (String loc : locations) {
            JMenuItem item = MDIApplication.findMenu((JComponent)menus.getLast(), loc);
            if (item == null) {
                return false;
            }
            menus.add(item);
        }
        JMenuItem item = (JMenuItem)menus.pollLast();
        if (menus.getLast() instanceof JMenu) {
            ((JMenu)menus.getLast()).remove(item);
        } else {
            ((JComponent)menus.getLast()).remove(item);
        }
        while (menus.size() > 1 && (menu = (JMenu)menus.pollLast()).getMenuComponentCount() == 0) {
            if (menus.getLast() instanceof JMenu) {
                ((JMenu)menus.getLast()).remove(menu);
                continue;
            }
            ((JComponent)menus.getLast()).remove(menu);
        }
        return true;
    }

    public final PageManager getPageManager() {
        if (this.pageManager == null) {
            this.setPageManager(this.createPageManager());
        }
        return this.pageManager;
    }

    public void setPageManager(PageManager manager) {
        if (manager == this.pageManager) {
            return;
        }
        Component oldEmbodiment = null;
        if (this.pageManager != null) {
            oldEmbodiment = this.pageManager.getEmbodiment();
        }
        this.switchPageManager(this.pageManager, manager);
        if (this.pageManager != null) {
            Container parent = oldEmbodiment.getParent();
            int index = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                if (parent.getComponent(i) != oldEmbodiment) continue;
                index = i;
                break;
            }
            parent.remove(index);
            Component page = manager.getEmbodiment();
            MDIApplication.updateComponentTreeUI(page);
            parent.add(page, index);
            parent.validate();
            this.getCommandProcessor().setChanged();
        }
        this.pageManager = manager;
    }

    public PageManager getControlManager() {
        if (this.controlManager == null) {
            this.setControlManager(this.createControlManager());
        }
        return this.controlManager;
    }

    public void setControlManager(PageManager manager) {
        if (manager == this.controlManager) {
            return;
        }
        this.switchPageManager(this.controlManager, manager);
        this.controlManager = manager;
    }

    public PageManager getConsoleManager() {
        if (this.consoleManager == null) {
            this.setConsoleManager(this.createConsoleManager());
        }
        return this.consoleManager;
    }

    public void setConsoleManager(PageManager manager) {
        if (manager == this.consoleManager) {
            return;
        }
        this.switchPageManager(this.consoleManager, manager);
        this.consoleManager = manager;
    }

    protected PageManager createPageManager() {
        return this.createManager("pageManager");
    }

    protected PageManager createControlManager() {
        return this.createManager("controlManager");
    }

    protected PageManager createConsoleManager() {
        PageManager p = this.createManager("consoleManager");
        p.setPageManagerType("Console");
        return p;
    }

    protected PageManager createManager(String type) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> k = loader.loadClass(this.getUserProperties().getProperty(type));
            return (PageManager)k.newInstance();
        }
        catch (Exception x) {
            throw new Application.InitializationException("Could not create PageManager: " + type, x);
        }
    }

    private void switchPageManager(PageManager oldManager, PageManager newManager) {
        newManager.setActive(true);
        if (oldManager != null) {
            List<PageListener> listeners = oldManager.getPageListenerList();
            oldManager.removeAllPageListeners();
            List<PageContext> l = oldManager.pages();
            Iterator<PageListener> i = listeners.iterator();
            while (i.hasNext()) {
                newManager.addPageListener(i.next());
            }
            newManager.init(l, oldManager.getSelectedPage());
            oldManager.setActive(false);
        } else {
            newManager.addPageListener(this.pageListener);
        }
    }

    public void setSelectedPageManager(PageManager manager) {
        if (manager == this.selectedPageManager) {
            return;
        }
        if (this.selectedPageManager != null) {
            this.getCommandTargetManager().remove((CommandGroup)this.selectedPageManager.getCommandProcessor());
        }
        this.getCommandTargetManager().add((CommandGroup)manager.getCommandProcessor());
        this.selectedPageManager = manager;
    }

    public PageManager selectedPageManager() {
        return this.selectedPageManager;
    }

    private void showControl(boolean show) {
        if (show && this.controlSplit == null) {
            Component pages = this.pageManager.getEmbodiment();
            Container parent = pages.getParent();
            parent.remove(pages);
            Component control = this.controlManager.getEmbodiment();
            MDIApplication.updateComponentTreeUI(control);
            this.controlSplit = new JSplitPane(1, control, pages);
            int pixels = PropertyUtilities.getInteger(this.getUserProperties(), "controlSize", -1);
            if (pixels > 0) {
                this.controlSplit.setDividerLocation(pixels);
            }
            parent.add(this.controlSplit);
            this.revalidate();
        } else if (!show && this.controlSplit != null) {
            PropertyUtilities.setInteger(this.getUserProperties(), "controlSize", this.controlSplit.getDividerLocation());
            Component pages = this.pageManager.getEmbodiment();
            Container parent = this.controlSplit.getParent();
            parent.remove(this.controlSplit);
            this.controlSplit.removeAll();
            this.controlSplit = null;
            parent.add(pages);
            this.revalidate();
        }
    }

    private void showConsole(boolean show) {
        if (show && this.consoleSplit == null) {
            Component old = this.getComponent(0);
            final int height = old.getHeight();
            this.remove(old);
            final int pixels = PropertyUtilities.getInteger(this.getUserProperties(), "consoleSize", -1);
            Component console = this.consoleManager.getEmbodiment();
            MDIApplication.updateComponentTreeUI(console);
            this.consoleSplit = new JSplitPane(0, old, console){
                int consoleSize;
                {
                    super(x0, x1, x2);
                    this.consoleSize = height > 0 ? -1 : pixels;
                }

                @Override
                public void doLayout() {
                    if (this.consoleSize > 0) {
                        int height2 = this.getHeight();
                        this.setDividerLocation(height2 - this.consoleSize);
                        this.consoleSize = -1;
                    }
                    super.doLayout();
                }
            };
            this.consoleSplit.setResizeWeight(1.0);
            if (pixels > 0 && height > 0) {
                this.consoleSplit.setDividerLocation(height - pixels);
            }
            this.add(this.consoleSplit);
            this.revalidate();
        } else if (!show && this.consoleSplit != null) {
            int consoleSize = this.consoleSplit.getHeight() - this.consoleSplit.getDividerLocation();
            PropertyUtilities.setInteger(this.getUserProperties(), "consoleSize", consoleSize);
            Component old = this.consoleSplit.getTopComponent();
            this.remove(this.consoleSplit);
            this.consoleSplit.removeAll();
            this.consoleSplit = null;
            this.add(old);
            this.revalidate();
        }
    }

    @Override
    protected CommandProcessor createCommandProcessor() {
        return new MDICommandProcessor();
    }

    protected class MDICommandProcessor
    extends Application.ApplicationCommandProcessor {
        protected MDICommandProcessor() {
            super(MDIApplication.this);
        }

        public void onTabbedPanes(boolean state) {
            if (state) {
                MDIApplication.this.setPageManager(new TabbedPageManager());
                MDIApplication.this.getUserProperties().setProperty("pageManager", MDIApplication.this.getPageManager().getClass().getName());
            }
        }

        public void enableTabbedPanes(BooleanCommandState state) {
            state.setEnabled(true);
            state.setSelected(MDIApplication.this.getPageManager() instanceof TabbedPageManager);
        }

        public void onInternalFrames(boolean state) {
            if (state) {
                MDIApplication.this.setPageManager(new InternalFramePageManager());
                MDIApplication.this.getUserProperties().setProperty("pageManager", MDIApplication.this.getPageManager().getClass().getName());
            }
        }

        public void enableInternalFrames(BooleanCommandState state) {
            state.setEnabled(true);
            state.setSelected(MDIApplication.this.getPageManager() instanceof InternalFramePageManager);
        }
    }

    private class MDIPageListener
    implements PageListener {
        private MDIPageListener() {
        }

        @Override
        public void pageChanged(PageEvent event) {
            PageManager manager;
            int id = event.getID();
            if (id == 4004) {
                PageManager manager2 = event.getPageContext().getPageManager();
                if (manager2.getPageCount() == 1) {
                    if (manager2 == MDIApplication.this.controlManager) {
                        MDIApplication.this.showControl(true);
                    }
                    if (manager2 == MDIApplication.this.consoleManager) {
                        MDIApplication.this.showConsole(true);
                    }
                }
            } else if (id == 4001 && (manager = event.getPageContext().getPageManager()).getPageCount() == 0) {
                if (manager == MDIApplication.this.controlManager) {
                    MDIApplication.this.showControl(false);
                }
                if (manager == MDIApplication.this.consoleManager) {
                    MDIApplication.this.showConsole(false);
                }
            }
        }
    }

    private class Location {
        String name;
        int group;
        int position;

        private Location() {
        }
    }
}

