/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPageDialog;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public abstract class AbstractMonitorView
implements MonitorView {
    protected AgentChannelsFilter filter;
    protected Descriptor descriptor;
    private boolean fixedDisplayList;
    private Set<String> displayChannels;
    protected final LinkedHashMap<String, ChannelHandle> path2data = new LinkedHashMap();

    @Override
    public AgentChannelsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        this.filter = filter;
        this.fixedDisplayList = filter != null && filter.getDisplayChannels() != null;
    }

    protected boolean isChannelListFixed() {
        return this.fixedDisplayList;
    }

    @Override
    public boolean isEmpty() {
        return this.path2data.isEmpty();
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.connect(event.getSource()));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        if (this.displayChannels == null) {
            List<String> fixed = this.filter.getDisplayChannels();
            if (fixed == null) {
                this.fixedDisplayList = false;
                this.displayChannels = Collections.emptySet();
            } else {
                this.fixedDisplayList = true;
                this.displayChannels = new HashSet<String>(fixed);
                SwingUtilities.invokeLater(() -> this.addChannels(event.getSource(), fixed.stream().collect(Collectors.toMap(dp -> dp, dp -> null))));
            }
        }
        this.update(event);
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        this.update(event);
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        this.update(event);
        SwingUtilities.invokeLater(() -> this.disconnect(event.getSource()));
    }

    /*
     * WARNING - void declaration
     */
    private void update(AgentStatusEvent event) {
        if (this.fixedDisplayList) {
            LinkedHashMap<String, Map.Entry> changedChannels = new LinkedHashMap<String, Map.Entry>();
            for (AgentChannel agentChannel : event.getAddedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, new AbstractMap.SimpleEntry<AgentChannel, Object>(agentChannel, null));
                }
            }
            for (AgentChannel agentChannel : event.getRemovedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, null);
                }
            }
            for (Map.Entry entry : event.getStatusChanges().entrySet()) {
                for (String string : this.filter.getDisplayPath((AgentChannel)entry.getKey())) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, entry);
                }
            }
            SwingUtilities.invokeLater(() -> this.updateChannels(event.getSource(), changedChannels));
        } else {
            void var4_14;
            LinkedHashMap<String, AgentChannel> addedChannels = null;
            for (AgentChannel agentChannel : event.getAddedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (addedChannels == null) {
                        addedChannels = new LinkedHashMap<String, AgentChannel>();
                    }
                    addedChannels.put(string, agentChannel);
                }
            }
            ArrayList<String> removedChannels = null;
            for (AgentChannel agentChannel : event.getRemovedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (removedChannels == null) {
                        removedChannels = new ArrayList<String>(event.getRemovedChannels().size());
                    }
                    removedChannels.add(string);
                }
            }
            Object var4_13 = null;
            for (Map.Entry<AgentChannel, List<String>> entry : event.getStatusChanges().entrySet()) {
                for (String displayPath : this.filter.getDisplayPath(entry.getKey())) {
                    if (var4_14 == null) {
                        LinkedHashMap linkedHashMap = new LinkedHashMap();
                    }
                    var4_14.put(displayPath, entry);
                }
            }
            LinkedHashMap<String, AgentChannel> linkedHashMap = addedChannels;
            ArrayList<String> arrayList = removedChannels;
            void var7_40 = var4_14;
            SwingUtilities.invokeLater(() -> this.lambda$update$6(linkedHashMap, event, arrayList, (Map)var7_40));
        }
    }

    protected void connect(AgentInfo agent) {
    }

    protected void disconnect(AgentInfo agent) {
    }

    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        boolean modified = false;
        for (Map.Entry<String, AgentChannel> e : channels.entrySet()) {
            ChannelHandle handle;
            String path = e.getKey();
            modified = this.path2data.put(path, handle = this.createChannelHandle(path, e.getValue(), null)) == null || modified;
        }
        if (modified) {
            this.resetChannels();
        }
    }

    protected void removeChannels(AgentInfo agent, List<String> paths) {
        boolean modified = false;
        for (String path : paths) {
            modified = this.path2data.remove(path) != null || modified;
        }
        if (modified) {
            this.resetChannels();
        }
    }

    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        channels.forEach((path, e) -> {
            ChannelHandle handle = this.path2data.get(path);
            if (handle != null && handle.getView() != null) {
                if (!Objects.equals(handle.getChannel(), e.getKey())) {
                    handle.setChannel((AgentChannel)e.getKey());
                    handle.getView().update(handle, null);
                } else {
                    handle.getView().update(handle, (List)e.getValue());
                }
            }
        });
    }

    protected void resetChannels() {
    }

    protected ChannelHandle createChannelHandle(String path, AgentChannel channel, ChannelDisplay view) {
        return new DefaultChannelHandle(path, channel, view);
    }

    @Override
    public Descriptor save() {
        return this.descriptor;
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        }
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public static class Descriptor
    implements MonitorView.Descriptor {
        private MonitorPageDialog.Descriptor creator;
        private String name;

        @Override
        public Serializable getCreator() {
            return this.creator;
        }

        @Override
        public void setCreator(Serializable creator) {
            if (creator instanceof MonitorPageDialog.Descriptor) {
                this.creator = (MonitorPageDialog.Descriptor)creator;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }
    }

    public static class DefaultChannelHandle
    implements ChannelHandle {
        private String path;
        private AgentChannel channel;
        private ChannelDisplay view;

        public DefaultChannelHandle(String path, AgentChannel channel, ChannelDisplay view) {
            this.path = path;
            this.channel = channel;
            this.view = view;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public AgentChannel getChannel() {
            return this.channel;
        }

        @Override
        public ChannelDisplay getView() {
            return this.view;
        }

        @Override
        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public void setChannel(AgentChannel channel) {
            this.channel = channel;
        }

        @Override
        public void setView(ChannelDisplay view) {
            this.view = view;
        }
    }

    public static interface ChannelDisplay {
        public void update(ChannelHandle var1, List<String> var2);
    }

    public static interface ChannelHandle {
        public AgentChannel getChannel();

        public String getPath();

        public ChannelDisplay getView();

        public void setPath(String var1);

        public void setChannel(AgentChannel var1);

        public void setView(ChannelDisplay var1);
    }
}

