/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;

public class AlertEvent
extends EventObject {
    private final Alert alert;
    private final RaisedAlertSummary summary;
    private final List<String> clear;

    public AlertEvent(String source, Alert alert, RaisedAlertSummary summary) {
        super(source);
        this.alert = alert;
        this.summary = summary;
        this.clear = null;
    }

    public AlertEvent(String source, String[] clearedIDs, RaisedAlertSummary summary) {
        super(source);
        this.alert = null;
        this.summary = summary;
        this.clear = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(clearedIDs)));
    }

    @Override
    public String getSource() {
        return (String)super.getSource();
    }

    public Alert getAlert() {
        return this.alert;
    }

    public AlertState getLevel() {
        return this.alert == null ? AlertState.NOMINAL : this.summary.getRaisedAlert(this.alert.getAlertId()).getLatestAlertState();
    }

    public RaisedAlertSummary getSummary() {
        return this.summary;
    }

    public List<String> getClearedIds() {
        return this.clear;
    }

    @Override
    public String toString() {
        return this.getSource() + ": " + this.getAlert();
    }
}

