/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.configdb.model.PathObject;

@Entity
@Immutable
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"agentName", "componentName", "parameterName", "typeName", "category"})})
public class ConfigurationParameter
implements Serializable,
PathObject {
    private static final long serialVersionUID = 5660908759518934491L;
    private long id;
    private String agentName;
    ParameterPath parameterPath;
    String typeName;
    protected String descriptionStr;
    private String simpleName;
    private String category;
    private int level = 0;

    protected ConfigurationParameter() {
    }

    public ConfigurationParameter(String agentName, ParameterPath path, String typeName, String description, String simpleName, String category, int level) {
        this.agentName = agentName;
        this.parameterPath = path;
        this.typeName = typeName;
        this.descriptionStr = description;
        this.simpleName = simpleName;
        this.category = category;
        this.level = level;
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public ParameterPath getParameterPath() {
        return this.parameterPath;
    }

    void setParameterPath(ParameterPath parameterPath) {
        this.parameterPath = parameterPath;
        this.simpleName = parameterPath.toString();
    }

    public String getDescriptionStr() {
        return this.descriptionStr;
    }

    void setDescriptionStr(String descriptionStr) {
        this.descriptionStr = descriptionStr;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    void setSimpleName(String simpleName) {
        if (this.simpleName == null || "".equals(this.simpleName)) {
            this.simpleName = simpleName;
        }
    }

    public String getCategory() {
        return this.category;
    }

    void setCategory(String category) {
        this.category = category;
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    @Override
    @Transient
    public ParameterPath getPath() {
        return this.parameterPath;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return "{" + this.getId() + ": path=" + this.parameterPath.toString() + '}';
    }
}

