/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.stack.MembershipChangePolicy;
import org.lsst.ccs.messaging.jgroups.CCSAddress;

public class CCSMembershipPolicy
implements MembershipChangePolicy {
    public List<Address> getNewMembership(Collection<Address> current_members, Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspects) {
        return new Membership().add(current_members).add(joiners).remove(leavers).remove(suspects).sort().getMembers();
    }

    public List<Address> getNewMembership(Collection<Collection<Address>> subviews) {
        Membership m = new Membership();
        subviews.forEach(view -> m.add((Collection<Address>)view));
        return m.sort().getMembers();
    }

    private static final class Membership {
        private final ArrayList<Address> data = new ArrayList(128);

        private Membership() {
        }

        Membership add(Address a) {
            if (a != null && !this.data.contains(a)) {
                this.data.add(a);
            }
            return this;
        }

        Membership add(Membership m) {
            if (m != null) {
                m.data.forEach(a -> this.add((Address)a));
            }
            return this;
        }

        Membership add(Collection<Address> addresses) {
            if (addresses != null) {
                addresses.forEach(a -> this.add((Address)a));
            }
            return this;
        }

        Membership remove(Collection<Address> aa) {
            if (aa != null) {
                this.data.removeAll(aa);
            }
            return this;
        }

        Membership sort() {
            this.data.sort((a1, a2) -> {
                if (a1 instanceof CCSAddress) {
                    if (a2 instanceof CCSAddress) {
                        return Long.compare(((CCSAddress)((Object)a1)).getRank(), ((CCSAddress)((Object)a2)).getRank());
                    }
                    return -1;
                }
                if (a2 instanceof CCSAddress) {
                    return 1;
                }
                return a1.compareTo(a2);
            });
            return this;
        }

        List<Address> getMembers() {
            return new ArrayList<Address>(this.data);
        }
    }
}

