/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.software.versions.puglish.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="publish", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PublishPlugin
extends AbstractMojo {
    private final Client client = ClientBuilder.newClient();
    private WebTarget serv;
    private static final ObjectMapper mapper = new ObjectMapper();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.getPackaging().equals("jar")) {
            this.getLog().info((CharSequence)"Skipping publishing artifacts for non \"jar\" packaging project");
            return;
        }
        this.serv = this.client.target("https://srs.slac.stanford.edu/releaseManagement/");
        ArrayList<String> allArtifacts = new ArrayList<String>();
        for (Artifact a : this.project.getArtifacts()) {
            if (!a.getType().equals("jar")) continue;
            allArtifacts.add(a.toString());
        }
        Collections.sort(allArtifacts);
        String thisArtifact = this.project.getArtifact().toString();
        ArtifactsPublicationPayload payload = new ArtifactsPublicationPayload(thisArtifact, allArtifacts);
        try (Response response = this.serv.path("publishArtifacts").request(new String[]{"application/json"}).post(Entity.entity((Object)payload, (String)"application/json"));){
            if (response.getStatus() == 200) {
                this.getLog().info((CharSequence)"Successfully published artifacts.");
            } else {
                RuntimeException re = new RuntimeException("Failed to publish artifacts: " + response.toString());
                this.getLog().warn((CharSequence)re.getMessage());
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Exception while publishing artifacts.", (Throwable)e);
        }
    }

    public static class ArtifactsPublicationPayload {
        public final String thisArtifact;
        public final List<String> allArtifacts;

        ArtifactsPublicationPayload(String thisArtifact, List<String> allArtifacts) {
            this.thisArtifact = thisArtifact;
            this.allArtifacts = allArtifacts;
        }

        public String toString() {
            try {
                return "{ \"artifact\" : " + this.thisArtifact + ", \"dependencies\":" + mapper.writeValueAsString(this.allArtifacts) + "}";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

