/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginParametersValidator;
import org.apache.maven.plugin.internal.MavenPluginConfigurationValidator;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=MavenPluginConfigurationValidator.class)
class DeprecatedPluginValidator
extends AbstractMavenPluginParametersValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecatedPluginValidator.class);

    DeprecatedPluginValidator() {
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is deprecated: " + parameter.getDeprecated();
    }

    @Override
    public void validate(MojoDescriptor mojoDescriptor, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (!LOGGER.isWarnEnabled()) {
            return;
        }
        if (mojoDescriptor.getDeprecated() != null) {
            this.logDeprecatedMojo(mojoDescriptor);
        }
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(parameter -> parameter.getDeprecated() != null).filter(Parameter::isEditable).forEach(parameter -> this.checkParameter((Parameter)parameter, pomConfiguration, expressionEvaluator));
    }

    private void checkParameter(Parameter parameter, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        PlexusConfiguration config = pomConfiguration.getChild(parameter.getName(), false);
        if (DeprecatedPluginValidator.isValueSet(config, expressionEvaluator)) {
            this.logParameter(parameter);
        }
    }

    private void logDeprecatedMojo(MojoDescriptor mojoDescriptor) {
        String message = MessageUtils.buffer().warning((Object)"Goal '").warning((Object)mojoDescriptor.getGoal()).warning((Object)"' is deprecated: ").warning((Object)mojoDescriptor.getDeprecated()).toString();
        LOGGER.warn(message);
    }
}

