/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.alert.AlertService;

public class PulseService
implements ServiceLifecycle,
HasLifecycle,
AgentService {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private static final String REPORT_LEVEL = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.pulse.level", "WARNING");
    private static final long PERIOD = 1000L;
    private static final long VETO_TIME = 60000L;
    private static final long VETO_FACTOR = 2L;
    private static final long MEMORY_MIN = 50000000L;
    private static final long MEMORY_MIN_KILL = 1000000L;
    private static final long GC_MAX = 2500L;
    private static final Alert ALERT_FREEZE = new Alert("JVM/freeze", "JVM has been unresponsive for more than 1000 ms.");
    private static final Alert ALERT_MEM_MIN = new Alert("JVM/memory/available", "JVM available memory is below 50 MB.");
    private static final Alert ALERT_GC = new Alert("JVM/gc/duration", "Garbage collection runs for more than 2500 ms.");
    private final ScheduledThreadPoolExecutor exec = "OFF".equals(REPORT_LEVEL) ? null : new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        private final ThreadFactory f = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.f.newThread(r);
            t.setDaemon(true);
            t.setName(PulseService.this.getAgentServiceName());
            return t;
        }
    });
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private ScheduledFuture<?> checkTask;
    private long prevTime = System.currentTimeMillis() + 3600000L;
    private long prevDelay;
    private long prevWarnTime;
    private long prevMemTime = System.currentTimeMillis();
    private String statusFREEZE;
    private String statusMEM_MIN;
    private final Map<String, Long> statusGC = new ConcurrentHashMap<String, Long>();

    @Override
    public void start() {
        if (this.exec == null) {
            this.log.info("PULSE service desabled.");
        } else {
            AlertService service = this.agent.getAgentService(AlertService.class);
            service.registerAlert(ALERT_FREEZE);
            service.registerAlert(ALERT_MEM_MIN);
            this.checkTask = this.exec.scheduleWithFixedDelay(this::check, 1000L, 1000L, TimeUnit.MILLISECONDS);
            StringBuilder sb = new StringBuilder("Starting PULSE service with reporting level ").append(REPORT_LEVEL);
            try {
                NotificationListener notificationListener = (notification, handback) -> {
                    if (notification.getType().equals("com.sun.management.gc.notification")) {
                        GarbageCollectionNotificationInfo gc = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                        String gcName = gc.getGcName();
                        String gcAct = gc.getGcAction();
                        GcInfo info = gc.getGcInfo();
                        long dura = info.getDuration();
                        if (dura > 2500L) {
                            StringBuilder s = new StringBuilder("PULSE: Long Garbage Collector run: ");
                            s.append(dura).append(" ms.");
                            s.append(" GC: ").append(gcName).append(", action: ").append(gcAct).append(", cause: ").append(gc.getGcCause()).append(".");
                            this.report(ALERT_GC, AlertState.WARNING, s.toString(), new Serializable[0]);
                            this.statusGC.put(gcName + gcAct, dura);
                        } else {
                            Long prev = this.statusGC.remove(gcName + gcAct);
                            if (prev != null && this.statusGC.isEmpty()) {
                                this.report(ALERT_GC, AlertState.NOMINAL, "Garbage collection times are back to normal.", new Serializable[0]);
                            }
                        }
                    }
                };
                for (java.lang.management.GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                    try {
                        ((NotificationEmitter)((Object)gc)).addNotificationListener(notificationListener, null, null);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
            catch (RuntimeException x) {
                sb.append(". No notifications from GarbageCollectorMXBean");
            }
            this.log.info(sb.append(".").toString());
        }
    }

    @Override
    public void shutdown() {
        if (this.exec != null) {
            this.checkTask.cancel(true);
            this.exec.shutdownNow();
        }
    }

    @Override
    public String getAgentServiceName() {
        return "pulseService";
    }

    private void check() {
        long time = System.currentTimeMillis();
        long delay = time - this.prevTime - 1000L;
        if (delay > 1000L) {
            if (time - this.prevWarnTime > 60000L || delay > this.prevDelay * 2L) {
                Object rt2;
                StringBuilder sb = new StringBuilder();
                sb.append("PULSE: Freeze ").append(delay).append(" ms.");
                try {
                    rt2 = ManagementFactory.getRuntimeMXBean();
                    long now = rt2.getUptime();
                    sb.append(" GC: ");
                    boolean hasGC = false;
                    for (java.lang.management.GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                        GcInfo info;
                        if (!(gc instanceof GarbageCollectorMXBean) || (info = ((GarbageCollectorMXBean)gc).getLastGcInfo()) == null) continue;
                        sb.append(gc.getName()).append(" from ").append(info.getStartTime() - now).append(" to ").append(info.getEndTime() - now).append(" for ").append(info.getDuration()).append(", ");
                        hasGC = true;
                    }
                    if (hasGC) {
                        sb.delete(sb.length() - 2, sb.length());
                    }
                }
                catch (RuntimeException rt2) {
                    // empty catch block
                }
                rt2 = Runtime.getRuntime();
                long free = ((Runtime)rt2).freeMemory();
                long max = ((Runtime)rt2).maxMemory();
                long total = ((Runtime)rt2).totalMemory();
                sb.append(". Memory: used ").append((total - free) / 1000000L).append(" MB, available ").append((max - total + free) / 1000000L).append(" MB.");
                this.statusFREEZE = sb.toString();
                this.report(ALERT_FREEZE, AlertState.WARNING, this.statusFREEZE, new Serializable[0]);
                this.prevWarnTime = time = System.currentTimeMillis();
            }
        } else if (this.statusFREEZE != null) {
            this.report(ALERT_FREEZE, AlertState.NOMINAL, "Last check ran normally.", new Serializable[0]);
            this.statusFREEZE = null;
            time = System.currentTimeMillis();
        }
        this.prevDelay = delay;
        if (time - this.prevMemTime > 60000L) {
            long total;
            long used;
            Runtime rt = Runtime.getRuntime();
            long free = rt.freeMemory();
            long max = rt.maxMemory();
            long avail = max - (used = (total = rt.totalMemory()) - free);
            if (avail < 50000000L) {
                StringBuilder sb = new StringBuilder("PULSE: Low available memory: ").append(avail / 1000000L).append(" MB.");
                sb.append(" Max: ").append(max / 1000000L).append(" MB,");
                sb.append(" Allocated: ").append(total / 1000000L).append(" MB,");
                sb.append(" Used: ").append(used / 1000000L).append(" MB.");
                this.statusMEM_MIN = sb.toString();
                this.report(ALERT_MEM_MIN, AlertState.WARNING, this.statusMEM_MIN, new Serializable[0]);
                if (this.agent.getAgentInfo().isGraphicalConsole() && avail < 1000000L) {
                    this.log.severe("I'm running out of memory. Shutting down to avoid causing problems for other applications.");
                    try {
                        this.agent.shutdownAgent();
                    }
                    catch (Exception exception) {}
                }
            } else if (this.statusMEM_MIN != null) {
                this.report(ALERT_MEM_MIN, AlertState.NOMINAL, "Available memory is back above threshold.", new Serializable[0]);
                this.statusMEM_MIN = null;
            }
            this.prevMemTime = time = System.currentTimeMillis();
        }
        this.prevTime = time;
    }

    private void report(Alert alert, AlertState severity, String message, Serializable ... data) {
        if (alert == null || "LOG".equals(REPORT_LEVEL)) {
            Level level = severity == AlertState.NOMINAL ? Level.INFO : Level.WARNING;
            this.log.log(level, message);
        } else {
            try {
                AlertService service = this.agent.getAgentService(AlertService.class);
                service.raiseAlert(alert, severity, message);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

