/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class UDPDiscoverySender
implements AutoCloseable {
    private static final Log log = LogManager.getLog(UDPDiscoverySender.class);
    private final MulticastSocket localSocket;
    private final InetAddress multicastAddress;
    private final int multicastPort;
    private final StandardSerializer serializer = new StandardSerializer();

    public UDPDiscoverySender(String host, int port, int udpTTL) throws IOException {
        try {
            log.debug("Constructing socket for sender on port [{0}]", port);
            this.localSocket = new MulticastSocket(port);
            if (udpTTL > 0) {
                log.debug("Setting datagram TTL to [{0}]", udpTTL);
                this.localSocket.setTimeToLive(udpTTL);
            }
            this.multicastAddress = InetAddress.getByName(host);
        }
        catch (IOException e) {
            log.error("Could not bind to multicast address [{0}]", host, e);
            throw e;
        }
        this.multicastPort = port;
    }

    @Override
    public void close() {
        if (this.localSocket != null && !this.localSocket.isClosed()) {
            this.localSocket.close();
        }
    }

    public void send(UDPDiscoveryMessage message) throws IOException {
        if (this.localSocket == null) {
            throw new IOException("Socket is null, cannot send message.");
        }
        if (this.localSocket.isClosed()) {
            throw new IOException("Socket is closed, cannot send message.");
        }
        log.debug("sending UDPDiscoveryMessage, address [{0}], port [{1}], message = {2}", this.multicastAddress, this.multicastPort, message);
        try {
            byte[] bytes = this.serializer.serialize(message);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.multicastAddress, this.multicastPort);
            log.debug("Sending DatagramPacket. bytes.length [{0}] to {1}:{2}", bytes.length, this.multicastAddress, this.multicastPort);
            this.localSocket.send(packet);
        }
        catch (IOException e) {
            log.error("Error sending message", e);
            throw e;
        }
    }

    public void requestBroadcast() throws IOException {
        log.debug("sending requestBroadcast");
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setRequesterId(CacheInfo.listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.REQUEST);
        this.send(message);
    }

    public void passiveBroadcast(String host, int port, ArrayList<String> cacheNames) throws IOException {
        this.passiveBroadcast(host, port, cacheNames, CacheInfo.listenerId);
    }

    protected void passiveBroadcast(String host, int port, ArrayList<String> cacheNames, long listenerId) throws IOException {
        log.debug("sending passiveBroadcast");
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.PASSIVE);
        this.send(message);
    }

    public void removeBroadcast(String host, int port, ArrayList<String> cacheNames) throws IOException {
        this.removeBroadcast(host, port, cacheNames, CacheInfo.listenerId);
    }

    protected void removeBroadcast(String host, int port, ArrayList<String> cacheNames, long listenerId) throws IOException {
        log.debug("sending removeBroadcast");
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.REMOVE);
        this.send(message);
    }
}

