/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;

public class ComponentConfigurationEnvironment {
    private final String name;
    private final ConfigurationService configurationCommandSet;

    ComponentConfigurationEnvironment(String name, ConfigurationService configurationCommandSet) {
        this.name = name;
        this.configurationCommandSet = configurationCommandSet;
    }

    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) {
        this.configurationCommandSet.change(this.name, parameterName, value);
    }

    @Command(description="submit a potential change for a parameter", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChange(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) {
        this.configurationCommandSet.submitChange(this.name, parameterName, value);
    }

    @Command(description="submit potential changes for parameters", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChanges(Map<String, Object> values) {
        try {
            for (Map.Entry<String, Object> parameter : values.entrySet()) {
                this.submitChange(parameter.getKey(), parameter.getValue());
            }
        }
        catch (Exception ex) {
            this.configurationCommandSet.dropAllSubmittedChanges();
            throw ex;
        }
    }

    @Command(description="displays the current values of the parameters that belong to the given categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=1)
    @Option.List(value={@Option(name="dirtyOnly", description="Only print information about dirty configuration parameters"), @Option(name="originTag", description="Show in which tag the parameter is defined")})
    public String printComponentConfigurationParameters(Options options, String ... categories) {
        return this.configurationCommandSet.printConfigParameters(options, this.name, categories);
    }

    @Command(description="prints the current state of the submitted changes", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, String> getSubmittedChanges() {
        return this.configurationCommandSet.getSubmittedChangesForComponent(this.name);
    }

    @Command(name="cancelSubmittedChanges", description="drops the submitted changes for this component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropSubmittedChanges() {
        this.configurationCommandSet.dropSubmittedChangesForComponent(this.name);
    }

    @Command(name="applySubmittedChangesForComponent", description="commit the submitted changes for this component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void commitSubmittedChangesForComponent() {
        this.configurationCommandSet.commitBulkChangeForComponent(this.name);
    }
}

