/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.lsst.ccs.command.SupportedOption;

public class Options
implements Serializable {
    private final Set<String> options = new HashSet<String>();
    private static final long serialVersionUID = 345738952754085472L;

    public Options() {
    }

    public Options(Options o) {
        this.options.addAll(o.options);
    }

    public Options withOption(String opt) {
        this.options.add(opt);
        return this;
    }

    public boolean hasOption(String option) {
        return this.hasOption(SupportedOption.getSupportedOption(option));
    }

    public boolean hasOption(SupportedOption option) {
        return this.options.contains(option.getSingleLetterName()) || this.options.contains(option.getName());
    }

    public String toString() {
        return "Options{options=" + this.options + '}';
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public Set<String> getOptions() {
        return new LinkedHashSet<String>(this.options);
    }

    public void removeOption(SupportedOption option) {
        this.options.remove(option.getName());
        this.options.remove(option.getSingleLetterName());
    }
}

