/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.web.rest.file.server.VersionedFile;

public class VersionedFileTest {
    private static Path tempDir;

    @BeforeAll
    public static void setUpClass() throws IOException {
        tempDir = Files.createTempDirectory("versions", new FileAttribute[0]);
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        Files.walk(tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void genericTest() throws IOException, DiffException {
        String content = "Just Testing";
        String content2 = "Just Testing some more";
        VersionedFile vf = VersionedFile.create((Path)tempDir.resolve("test.file"), (byte[])content.getBytes());
        Assertions.assertEquals((int)1, (int)vf.getDefaultVersion());
        Assertions.assertEquals((int)1, (int)vf.getLatestVersion());
        Assertions.assertFalse((boolean)vf.isHidden(1));
        Path file = vf.getDefault();
        Assertions.assertEquals((Object)content, (Object)new String(Files.readAllBytes(file)));
        int nv = vf.addVersion(content2.getBytes(), false);
        Assertions.assertEquals((int)2, (int)nv);
        Assertions.assertEquals((int)1, (int)vf.getDefaultVersion());
        Assertions.assertEquals((int)2, (int)vf.getLatestVersion());
        Assertions.assertFalse((boolean)vf.isHidden(2));
        int[] versions = vf.getVersions();
        Assertions.assertEquals((int)2, (int)versions.length);
        vf.setDefaultVersion(2);
        Assertions.assertEquals((int)2, (int)vf.getDefaultVersion());
        Assertions.assertEquals((int)2, (int)vf.getLatestVersion());
        Path file1 = vf.getPathForVersion(1);
        Path file2 = vf.getPathForVersion(2);
        List<String> lines1 = Files.readAllLines(file1);
        List<String> lines2 = Files.readAllLines(file2);
        Patch diff = DiffUtils.diff(lines1, lines2);
        List deltas = diff.getDeltas();
        Assertions.assertEquals((int)1, (int)deltas.size());
        Assertions.assertEquals((Object)content, ((AbstractDelta)deltas.get(0)).getSource().getLines().get(0));
        Assertions.assertEquals((Object)content2, ((AbstractDelta)deltas.get(0)).getTarget().getLines().get(0));
        List generateUnifiedDiff = UnifiedDiffUtils.generateUnifiedDiff((String)"version1", (String)"version2", lines1, (Patch)diff, (int)2);
        Assertions.assertEquals((Object)("-" + content), generateUnifiedDiff.get(3));
        Assertions.assertEquals((Object)("+" + content2), generateUnifiedDiff.get(4));
        int nv2 = vf.addVersion(content2.getBytes(), true);
        Assertions.assertEquals((int)2, (int)nv2);
    }

    @Test
    void testHiddenVersions() throws IOException {
        String content = "Just Testing";
        VersionedFile vf = VersionedFile.create((Path)tempDir.resolve("test2.file"), (byte[])content.getBytes());
        int nv1 = vf.addVersion(content.getBytes(), false);
        int nv2 = vf.addVersion(content.getBytes(), false);
        vf.setHidden(nv1, true);
        Assertions.assertTrue((boolean)vf.isHidden(nv1));
        Assert.assertArrayEquals((int[])new int[]{vf.getDefaultVersion(), nv2}, (int[])vf.getVersions(false));
        vf.setHidden(nv1, false);
        Assertions.assertFalse((boolean)vf.isHidden(nv1));
        try {
            vf.setHidden(nv2, true);
            Assertions.fail((String)"Should not get here");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            vf.setHidden(vf.getDefaultVersion(), true);
            Assertions.fail((String)"Should not get here");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testConvert() throws IOException {
        String content = "Unversioned Content";
        Path testFile = tempDir.resolve("fileToConvert.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(testFile, new OpenOption[0]);){
            writer.write(content);
        }
        Assertions.assertTrue((boolean)Files.exists(testFile, new LinkOption[0]));
        VersionedFile vf = VersionedFile.convert((Path)testFile);
        Assertions.assertEquals((int)1, (int)vf.getDefaultVersion());
        Assertions.assertEquals((int)1, (int)vf.getLatestVersion());
    }
}

