/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import org.lsst.ccs.rest.file.server.client.implementation.AddJWTTokenRequestFilter;
import org.lsst.ccs.rest.file.server.client.implementation.AddProtcolVersionRequestFilter;
import org.lsst.ccs.rest.file.server.client.implementation.Cache;
import org.lsst.ccs.rest.file.server.client.implementation.CacheRequestFilter;
import org.lsst.ccs.rest.file.server.client.implementation.CacheResponseFilter;
import org.lsst.ccs.rest.file.server.client.implementation.RestClient;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileStore;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystemOptionsHelper;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystemProvider;
import org.lsst.ccs.rest.file.server.client.implementation.RestPath;
import org.lsst.ccs.rest.file.server.client.implementation.unixlike.AbstractFileSystem;
import org.lsst.ccs.rest.file.server.client.implementation.unixlike.AbstractPathBuilder;

public class RestFileSystem
extends AbstractFileSystem
implements AbstractPathBuilder {
    private static final Set<String> SUPPORTED_VIEWS = new HashSet<String>();
    private final RestFileSystemProvider provider;
    private final URI uri;
    private final RestFileSystemOptionsHelper options;
    private final RestClient restClient;
    private final Cache cache;
    private boolean offline = false;
    private static final Logger LOG;
    private final URI mountPoint;

    public RestFileSystem(RestFileSystemProvider provider, URI uri, Map<String, ?> env) throws IOException {
        this.provider = provider;
        uri = uri.getPath().endsWith("/") ? uri : UriBuilder.fromUri((URI)uri).path(uri.getPath() + "/").build(new Object[0]);
        this.options = new RestFileSystemOptionsHelper(env);
        this.mountPoint = this.options.getMountPoint();
        this.uri = uri;
        Client client = ClientBuilder.newBuilder().readTimeout(3L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).build();
        URI restURI = this.computeRestURI(client);
        if (this.options.getCacheOptions() != RestFileSystemOptions.CacheOptions.NONE) {
            this.cache = new Cache(this.options);
            client.register((Object)new CacheRequestFilter(this.cache, this.offline || this.options.getCacheFallback() == RestFileSystemOptions.CacheFallback.ALWAYS));
            client.register((Object)new CacheResponseFilter(this.cache));
        } else {
            this.cache = null;
        }
        client.register((Object)new AddProtcolVersionRequestFilter());
        Object jwt = env.get("JWTToken");
        if (jwt != null) {
            client.register((Object)new AddJWTTokenRequestFilter(jwt.toString()));
        }
        this.restClient = new RestClient(client, restURI, this.mountPoint);
    }

    private URI computeRestURI(Client client) throws IOException {
        RestFileSystemOptions.SSLOptions useSSL = this.options.isUseSSL();
        String schema = useSSL == RestFileSystemOptions.SSLOptions.TRUE ? "https" : "http";
        URI trialRestURI = UriBuilder.fromUri((URI)this.uri).scheme(schema).build(new Object[0]);
        if (useSSL == RestFileSystemOptions.SSLOptions.AUTO || this.options.getCacheFallback() == RestFileSystemOptions.CacheFallback.OFFLINE) {
            URI testURI = trialRestURI.resolve("rest/list/");
            try {
                Response response = client.target(testURI).request(new String[]{"application/json"}).head();
                if (response.getStatus() / 100 == 3) {
                    String location = response.getHeaderString("Location");
                    testURI = UriBuilder.fromUri((String)location).build(new Object[0]);
                    if ((response = client.target(testURI).request(new String[]{"application/json"}).head()).getStatus() != 200) {
                        throw new IOException("Cannot create rest file system, rc=" + response.getStatus() + "uri=" + testURI);
                    }
                    trialRestURI = testURI.resolve("../..");
                } else if (response.getStatus() != 200) {
                    throw new IOException("Cannot create rest file system, rc=" + response.getStatus() + "uri=" + testURI);
                }
            }
            catch (IOException | ProcessingException x) {
                if (this.options.getCacheOptions() == RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK && this.options.getCacheFallback() != RestFileSystemOptions.CacheFallback.NEVER) {
                    this.offline = true;
                    LOG.log(Level.WARNING, () -> this.lambda$computeRestURI$0((Exception)x));
                }
                if (x instanceof ProcessingException) {
                    throw RestClient.convertProcessingException((ProcessingException)x);
                }
                throw x;
            }
        }
        return trialRestURI;
    }

    Cache getCache() {
        return this.cache;
    }

    RestClient getClient() {
        return this.restClient;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.provider.dispose(this.getFullURI());
        this.restClient.close();
        if (this.cache != null) {
            this.cache.close();
        }
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.singletonList(new RestFileStore(this));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (more.length == 0) {
            return new RestPath(this, first);
        }
        return new RestPath(this, first + "/" + String.join((CharSequence)"/", more));
    }

    @Override
    public Path getPath(boolean isAbsolute, List<String> path) {
        return new RestPath(this, isAbsolute, path);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    URI getURI(String path) {
        return this.uri.resolve(path);
    }

    public URI getMountPoint() {
        return this.mountPoint;
    }

    URI getFullURI() {
        return this.uri.resolve(this.mountPoint);
    }

    static URI getFullURI(URI uri, Map<String, ?> env) {
        RestFileSystemOptionsHelper optionsHelper = new RestFileSystemOptionsHelper(env);
        URI restURI = uri.resolve(optionsHelper.getMountPoint());
        return restURI;
    }

    private /* synthetic */ String lambda$computeRestURI$0(Exception x) {
        return String.format("Rest File server running in offline mode: %s (%s)", this.uri, x.getMessage());
    }

    static {
        SUPPORTED_VIEWS.add("basic");
        SUPPORTED_VIEWS.add("versioned");
        LOG = Logger.getLogger(RestFileSystem.class.getName());
    }
}

