/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ClientTimeoutTest {
    private static final int port = 9998;
    private static final String host = "http://localhost/";
    private static HttpServer httpServer;

    @BeforeAll
    public static void setUpClass() throws URISyntaxException, IOException {
        URI baseUri = UriBuilder.fromUri((String)host).port(9998).build(new Object[0]);
        ResourceConfig config = new ResourceConfig(new Class[]{WelcomeMessage.class, WaitForever.class});
        httpServer = JdkHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)config, (boolean)true);
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        httpServer.stop(0);
    }

    @Test
    public void testServerTimeout() throws Exception {
        Client client = ClientBuilder.newBuilder().readTimeout(15L, TimeUnit.SECONDS).build();
        URI serverURI = new URI("http://localhost:9998/");
        URI welcomeRestURI = UriBuilder.fromUri((URI)serverURI).path("waitforever").queryParam("maxwait", new Object[]{1000L}).build(new Object[0]);
        WebTarget target = client.target(welcomeRestURI);
        Response r = target.request().get();
        Assert.assertTrue((r.getStatus() == 500 ? 1 : 0) != 0);
    }

    @Test
    public void testReadTimeout() throws Exception {
        Client client = ClientBuilder.newBuilder().readTimeout(1L, TimeUnit.SECONDS).build();
        URI serverURI = new URI("http://localhost:9998/");
        URI welcomeRestURI = UriBuilder.fromUri((URI)serverURI).path("waitforever").queryParam("maxwait", new Object[]{5000L}).build(new Object[0]);
        WebTarget target = client.target(welcomeRestURI);
        try {
            Response r = target.request().get();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
        }
    }

    @Path(value="/welcome")
    public static class WelcomeMessage {
        private String welcomeMessage = "Hello world!";

        @GET
        public String returnWelcomeMessage() {
            return this.welcomeMessage;
        }

        @PUT
        public String updateWelcomeMessage(String aNewMessage) {
            this.welcomeMessage = aNewMessage;
            return "Welcome message updated";
        }
    }

    @Path(value="/waitforever")
    public static class WaitForever {
        private final long wait = 1000L;

        @GET
        public String waitForever(@QueryParam(value="maxwait") int maxwait) {
            long overallWait = 0L;
            while (true) {
                if (overallWait >= (long)maxwait) {
                    throw new RuntimeException("Waited too long");
                }
                try {
                    Thread.sleep(1000L);
                    overallWait += 1000L;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

