/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributeView;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import org.lsst.ccs.rest.file.server.client.VersionedOpenOption;
import org.lsst.ccs.web.rest.file.server.TestServer;

public class ClientTest {
    private static TestServer testServer;
    private static FileSystem restfs;
    private static URI restRootURI;

    @BeforeAll
    public static void setUpClass() throws URISyntaxException, IOException {
        testServer = new TestServer();
        restRootURI = UriBuilder.fromUri((URI)testServer.getServerURI()).scheme("ccs").build(new Object[0]);
        restfs = FileSystems.newFileSystem(restRootURI, Collections.emptyMap());
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        restfs.close();
        testServer.shutdown();
    }

    @AfterEach
    public void cleanup() throws IOException {
        testServer.cleanFiles();
    }

    @Test
    public void localPathTest() throws IOException {
        Path path = Paths.get("xyz" + UUID.randomUUID(), new String[0]);
        Files.createFile(path, new FileAttribute[0]);
        Path absolute = path.toAbsolutePath();
        Assertions.assertNotEquals((Object)path, (Object)absolute);
        Assertions.assertTrue((boolean)Files.isSameFile(path, absolute));
        Files.delete(path);
    }

    @Test
    public void restPathTest() throws IOException {
        Path path = restfs.getPath("xyz" + UUID.randomUUID(), new String[0]);
        Path absolute = path.toAbsolutePath();
        Assertions.assertNotEquals((Object)path, (Object)absolute);
        Assertions.assertTrue((boolean)Files.isSameFile(path, absolute));
    }

    @Test
    public void localTest() throws IOException {
        Path tempDir = Files.createTempDirectory("rest-test", new FileAttribute[0]);
        Path localPath = tempDir.resolve("test.txt");
        Assertions.assertTrue((boolean)localPath.isAbsolute());
        String content = "This is a test file";
        try (BufferedWriter writer = Files.newBufferedWriter(localPath, new OpenOption[0]);){
            writer.append("This is a test file");
        }
        this.standardTest(localPath, "This is a test file");
    }

    @Test
    public void simpleTest() throws IOException {
        Path pathInRestServer = restfs.getPath("test2.txt", new String[0]);
        Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
        Assertions.assertFalse((boolean)pathInRestServer.isAbsolute());
        pathInRestServer = pathInRestServer.toAbsolutePath();
        String content = "This is a test file";
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[0]);){
            writer.append("This is a test file");
        }
        this.standardTest(pathInRestServer, "This is a test file");
    }

    private void standardTest(Path path, String content) throws IOException {
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Path parent = path.getParent();
        Assertions.assertTrue((boolean)Files.isDirectory(parent, new LinkOption[0]));
        List files = Files.list(parent).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)files.size());
        Assertions.assertTrue((boolean)Files.isSameFile(path, (Path)files.get(0)));
        List lines = Files.lines(path).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)content, lines.get(0));
        Assertions.assertEquals((long)content.length(), (long)Files.size(path));
        BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertEquals((long)content.length(), (long)attributes.size());
        Assertions.assertEquals((Object)"text/plain", (Object)Files.probeContentType(path));
        Path child = parent.resolve("newDir");
        Files.createDirectory(child, new FileAttribute[0]);
        Path newPath = child.resolve(path.getFileName());
        Files.move(path, newPath, new CopyOption[0]);
        Assertions.assertFalse((boolean)Files.exists(path, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(newPath, new LinkOption[0]));
        Files.delete(newPath);
        Assertions.assertFalse((boolean)Files.exists(newPath, new LinkOption[0]));
        Files.delete(child);
    }

    @Test
    public void nonFileTest() throws IOException {
        Path pathInRestServer = restfs.getPath("test3.txt", new String[0]);
        try {
            List lines = Files.lines(pathInRestServer).collect(Collectors.toList());
            Assertions.fail((String)"should not get here!");
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    @Test
    public void rewriteFile() throws IOException {
        Path pathInRestServer = restfs.getPath("test.txt", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, StandardOpenOption.CREATE_NEW);){
            writer.append("This is a test file");
        }
        try {
            writer = Files.newBufferedWriter(pathInRestServer, StandardOpenOption.CREATE_NEW);
            try {
                writer.append("This is a test file as well");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            Assertions.fail((String)"Should not get here!");
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void replaceExisting() throws IOException {
        Path pathInRestServer = restfs.getPath("test2.txt", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, StandardOpenOption.CREATE_NEW);){
            writer.append("This is a test file");
        }
        writer = Files.newBufferedWriter(pathInRestServer, StandardOpenOption.TRUNCATE_EXISTING);
        try {
            writer.append("This is a test file as well\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        writer = Files.newBufferedWriter(pathInRestServer, StandardOpenOption.APPEND);
        try {
            writer.append("This is a test file as well\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        long nlines = Files.lines(pathInRestServer).count();
        Assertions.assertEquals((long)2L, (long)nlines);
    }

    @Test
    public void simpleVersionTest() throws IOException {
        Path pathInRestServer = restfs.getPath("versioned.txt", new String[0]);
        Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
        String content = "This is a test file";
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[]{VersionOpenOption.LATEST});){
            writer.append("This is a test file");
        }
        this.standardTest(pathInRestServer, "This is a test file");
    }

    @Test
    public void pathBasedVersionTest() throws IOException {
        Path pathInRestServer = restfs.getPath("anotherVersioned.txt", new String[0]);
        Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
        String content = "This is a test file";
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[]{VersionOpenOption.LATEST});){
            writer.append("This is a test file");
        }
        BasicFileAttributes basicAttributes = Files.readAttributes(pathInRestServer, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertFalse((boolean)basicAttributes.isDirectory());
        VersionedFileAttributes versionAttributes = Files.readAttributes(pathInRestServer, VersionedFileAttributes.class, new LinkOption[0]);
        Assertions.assertTrue((versionAttributes.getDefaultVersion() == 1 ? 1 : 0) != 0);
        VersionedFileAttributeView versionView = Files.getFileAttributeView(pathInRestServer, VersionedFileAttributeView.class, new LinkOption[0]);
        Assertions.assertTrue((versionView.readAttributes().getDefaultVersion() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((versionView.readAttributes().getLatestVersion() == 1 ? 1 : 0) != 0);
        String newContent = "This is some new content";
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[0]);){
            writer.append("This is some new content");
        }
        Assertions.assertTrue((versionView.readAttributes().getDefaultVersion() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((versionView.readAttributes().getLatestVersion() == 2 ? 1 : 0) != 0);
        Path newPathInRestServer2 = restfs.getPath("anotherVersioned(2).txt", new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(newPathInRestServer2);){
            String newerContent = reader.readLine();
            Assertions.assertEquals((Object)"This is some new content", (Object)newerContent);
        }
        Path newPathInRestServer1 = restfs.getPath("anotherVersioned(1).txt", new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(newPathInRestServer1);){
            String newerContent = reader.readLine();
            Assertions.assertEquals((Object)"This is a test file", (Object)newerContent);
        }
        Path newPathInRestServerd = restfs.getPath("anotherVersioned(d).txt", new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(newPathInRestServerd);){
            String newerContent = reader.readLine();
            Assertions.assertEquals((Object)"This is a test file", (Object)newerContent);
        }
        Path newPathInRestServerl = restfs.getPath("anotherVersioned(l).txt", new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(newPathInRestServerl);){
            String newerContent = reader.readLine();
            Assertions.assertEquals((Object)"This is some new content", (Object)newerContent);
        }
    }

    @Test
    public void extendedVersionTest() throws IOException {
        List lines;
        BufferedReader reader;
        Path pathInRestServer = restfs.getPath("versioned.txt", new String[0]);
        Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
        String content = "This is a test file\nwith two lines";
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[]{VersionOpenOption.LATEST});){
            writer.append("This is a test file\nwith two lines");
        }
        BasicFileAttributes basicAttributes = Files.readAttributes(pathInRestServer, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertFalse((boolean)basicAttributes.isDirectory());
        VersionedFileAttributes versionAttributes = Files.readAttributes(pathInRestServer, VersionedFileAttributes.class, new LinkOption[0]);
        Assertions.assertTrue((versionAttributes.getDefaultVersion() == 1 ? 1 : 0) != 0);
        VersionedFileAttributeView versionView = Files.getFileAttributeView(pathInRestServer, VersionedFileAttributeView.class, new LinkOption[0]);
        Assertions.assertTrue((versionView.readAttributes().getDefaultVersion() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((versionView.readAttributes().getLatestVersion() == 1 ? 1 : 0) != 0);
        String newContent = "This is some new content";
        try (BufferedWriter writer2 = Files.newBufferedWriter(pathInRestServer, new OpenOption[0]);){
            writer2.append("This is some new content");
        }
        Assertions.assertTrue((versionView.readAttributes().getDefaultVersion() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((versionView.readAttributes().getLatestVersion() == 2 ? 1 : 0) != 0);
        versionView.setDefaultVersion(2);
        Assertions.assertTrue((versionView.readAttributes().getDefaultVersion() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((versionView.readAttributes().getLatestVersion() == 2 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)versionView.readAttributes().isHidden(1));
        Assertions.assertEquals((Object)"", (Object)versionView.readAttributes().getComment(1));
        versionView.setComment(2, "This is a comment");
        versionView.setHidden(1, true);
        Assertions.assertEquals((Object)"This is a comment", (Object)versionView.readAttributes().getComment(2));
        Assertions.assertTrue((boolean)versionView.readAttributes().isHidden(1));
        try {
            versionView.setHidden(2, true);
            Assertions.fail((String)"Should not get here");
        }
        catch (IOException writer2) {
            // empty catch block
        }
        String[] splitContent = "This is a test file\nwith two lines".split("\n");
        try (InputStream in = Files.newInputStream(pathInRestServer, new OpenOption[]{VersionedOpenOption.DIFF, VersionOpenOption.of((int)2), VersionOpenOption.of((int)1)});){
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                lines = reader.lines().collect(Collectors.toList());
                Assertions.assertEquals((int)6, (int)lines.size());
                Assertions.assertEquals((Object)("-" + splitContent[0]), lines.get(3));
                Assertions.assertEquals((Object)("-" + splitContent[1]), lines.get(4));
                Assertions.assertEquals((Object)"+This is some new content", lines.get(5));
            }
            finally {
                reader.close();
            }
        }
        in = Files.newInputStream(pathInRestServer, new OpenOption[]{VersionedOpenOption.DIFF, VersionOpenOption.of((int)1), VersionOpenOption.of((int)2)});
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                lines = reader.lines().collect(Collectors.toList());
                Assertions.assertEquals((int)6, (int)lines.size());
                Assertions.assertEquals((Object)("+" + splitContent[0]), lines.get(4));
                Assertions.assertEquals((Object)("+" + splitContent[1]), lines.get(5));
                Assertions.assertEquals((Object)"-This is some new content", lines.get(3));
            }
            finally {
                reader.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        in = Files.newInputStream(pathInRestServer, new OpenOption[]{VersionedOpenOption.DIFF});
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                lines = reader.lines().collect(Collectors.toList());
                Assertions.assertEquals((int)6, (int)lines.size());
                Assertions.assertEquals((Object)("-" + splitContent[0]), lines.get(3));
                Assertions.assertEquals((Object)("-" + splitContent[1]), lines.get(4));
                Assertions.assertEquals((Object)"+This is some new content", lines.get(5));
            }
            finally {
                reader.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        try {
            in = Files.newInputStream(pathInRestServer, new OpenOption[]{VersionedOpenOption.DIFF, VersionOpenOption.of((int)1)});
            try {
                Assertions.fail((String)"Should not get here");
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void pathTest() throws IOException {
        Path path = Paths.get(restRootURI.resolve("rhubarb/test.file"));
        Assertions.assertEquals((Object)"ccs", (Object)path.toUri().getScheme());
        Assertions.assertEquals((Object)"test.file", (Object)path.getFileName().toString());
        URI uri = URI.create("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/test/test.properties");
        Path path2 = Paths.get(uri);
        System.out.println(path2.toUri());
        BasicFileAttributes bfa = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
        System.out.println(bfa.isOther());
        FileSystem fs = FileSystems.getFileSystem(URI.create("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/"));
        fs.close();
    }

    @Test
    public void relativizeTest() throws IOException {
        FileSystem fs = restfs;
        Path path1 = fs.getPath("a", "b", "c");
        Path path2 = fs.getPath("a", new String[0]);
        Path path3 = path2.relativize(path1);
        Assertions.assertEquals((Object)"b/c", (Object)path3.toString());
        Path path4 = path1.relativize(path2);
        Assertions.assertEquals((Object)"../..", (Object)path4.toString());
    }
}

