/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import picocli.CommandLine;

@CommandLine.Command(name="mkdir", description={"Create a new directory"})
public class MakeDirectoryCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Parameters(paramLabel="<path>", description={"Path to directory to create"})
    private String path;
    @CommandLine.Option(names={"-p", "--parents"}, description={"no error if existing, make parent directories as needed"})
    private boolean createParents;

    @Override
    public Void call() throws IOException {
        try (FileSystem restfs = this.parent.createFileSystem();){
            Path restPath = restfs.getPath(this.path, new String[0]);
            if (this.createParents) {
                Files.createDirectories(restPath, new FileAttribute[0]);
            } else {
                Files.createDirectory(restPath, new FileAttribute[0]);
            }
            Void void_ = null;
            return void_;
        }
    }
}

