/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import picocli.CommandLine;

@CommandLine.Command(name="mv", description={"Move/rename a file or directory"})
public class MoveCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Parameters(paramLabel="<from>", description={"Source"})
    private String from;
    @CommandLine.Parameters(paramLabel="<to>", description={"Destination"})
    private String to;

    @Override
    public Void call() throws IOException {
        try (FileSystem restfs = this.parent.createFileSystem();){
            Path fromPath = restfs.getPath(this.from, new String[0]);
            Path toPath = restfs.getPath(this.to, new String[0]);
            Files.move(fromPath, toPath, new CopyOption[0]);
            Void void_ = null;
            return void_;
        }
    }
}

