/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class Versions
extends AbstractChannelsFilter {
    private final Pattern pat = Pattern.compile("([^/]+)/+ccsVersions/+([^/]+)/version");

    @Create(category="AgentChannelsFilter", name="Versions", path="Built-In/Versions", description="Channels filter that selects software versions channels.")
    public Versions() {
    }

    @Override
    public String getDisplayPath(String originPath) {
        Matcher m = this.pat.matcher(originPath);
        if (m.matches()) {
            return m.group(1) + "/" + m.group(2);
        }
        return null;
    }

    @Override
    public String getOriginPath(String displayPath) {
        String[] ss = displayPath.split("/");
        return ss.length == 2 ? ss[0] + "/ccsVersions/" + ss[1] + "/version" : null;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/ccsVersions/");
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? Collections.singletonList("value") : Arrays.asList("value", "HOST");
    }
}

