/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisLabel;
import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.DoubleNumberFormatter;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class DoubleAxis
extends AxisType
implements DoubleCoordinateTransformation {
    private final StringBuffer b = new StringBuffer();
    private final double log10 = Math.log(10.0);
    private final int majorTickLength = 5;
    private final int minorTickLength = 3;
    private final int maxCharsPerLabel = 5;
    private final int minSpaceBetweenLabels = 3;
    private final int minNumberOfDivisions = 1;
    private int nDivisions = 0;
    private double data_min = 0.0;
    private double data_max = 1.0;
    private double plot_min = 0.0;
    private double plot_max = 1.0;
    private AxisLabel[] labels;
    private double[] minorTickPositions;
    private boolean logarithmic;
    private int scale_power;
    private boolean useSuggestedRange = false;
    private boolean tryForNewLabelsOnExpansion;
    private boolean hideMinorTicks = false;

    public DoubleAxis() {
        this(false);
    }

    public DoubleAxis(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public void setLogarithmic(boolean logarithmic) {
        if (this.logarithmic != logarithmic) {
            this.labelsValid = false;
            this.logarithmic = logarithmic;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setUseSuggestedRange(boolean useSuggestedRange) {
        if (this.useSuggestedRange != useSuggestedRange) {
            this.labelsValid = false;
            this.useSuggestedRange = useSuggestedRange;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean getUseSuggestedRange() {
        return this.useSuggestedRange;
    }

    public void setMin(double data_min) {
        if (this.data_min != data_min) {
            this.labelsValid = false;
            this.data_min = data_min;
            this.plot_min = data_min;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public void setMax(double data_max) {
        if (this.data_max != data_max) {
            this.labelsValid = false;
            this.data_max = data_max;
            this.plot_max = data_max;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    @Override
    public double getPlotMin() {
        return this.plot_min;
    }

    @Override
    public double getPlotMax() {
        return this.plot_max;
    }

    public double getDataMin() {
        return this.data_min;
    }

    public double getDataMax() {
        return this.data_max;
    }

    private int stringWidth(FontMetrics fm, String s) {
        if (s.startsWith("e")) {
            return fm.stringWidth(s) + fm.stringWidth("10") - fm.charWidth('e');
        }
        return fm.stringWidth(s);
    }

    private int round(double d, boolean down) {
        block3: {
            double round;
            block2: {
                double minProximity = 1.0E-4;
                round = Math.round(d);
                if (d == round) break block2;
                double d2 = Math.abs(d - round);
                double d3 = d != 0.0 ? 1.0E-4 * Math.abs(d) : 1.0E-6;
                if (!(d2 < d3)) break block3;
            }
            return (int)round;
        }
        return down ? (int)Math.floor(d) : (int)Math.ceil(d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areEqual(double d1, double d2) {
        if (d1 == d2) return true;
        double d = Math.abs(d2 - d1);
        double d3 = d1 != 0.0 ? 1.0E-4 * d1 : 1.0E-6;
        if (!(d < Math.abs(d3))) return false;
        return true;
    }

    private int charsReq(int pow) {
        if (pow < 0) {
            return -pow + 2;
        }
        return pow + 1;
    }

    private void createNewLabels(int maxNumberOfDivisions) {
        this.labelsValid = true;
        double log_max = this.data_max == 0.0 ? 0.0 : Math.log(Math.abs(this.data_max)) / this.log10;
        int int_log_max = (int)Math.floor(log_max);
        this.scale_power = 0;
        if (int_log_max >= 5) {
            this.scale_power = int_log_max;
        } else if (int_log_max <= -5) {
            this.scale_power = int_log_max;
        }
        DoubleNumberFormatter format = new DoubleNumberFormatter(this.scale_power);
        if (this.logarithmic) {
            double log_min = this.data_min == 0.0 ? 0.0 : Math.log(Math.abs(this.data_min)) / this.log10;
            int min_int = this.round(log_min, this.useSuggestedRange);
            int max_int = this.round(log_max, !this.useSuggestedRange);
            int nDecades = max_int - min_int + 1;
            if (nDecades < (this.useSuggestedRange ? 3 : 2)) {
                this.tryForNewLabelsOnExpansion = true;
                this.minorTickPositions = null;
                int pow = (int)Math.floor(Math.log(this.data_max - this.data_min) / this.log10) - (maxNumberOfDivisions > 40 ? 2 : 1);
                if (this.scale_power > 0 || pow < 0) {
                    format.setFractionDigits(this.scale_power - pow);
                } else {
                    format.setFractionDigits(0);
                }
                double mag = Math.pow(10.0, pow);
                this.nDivisions = Math.max(maxNumberOfDivisions, 2);
                if (this.useSuggestedRange) {
                    this.plot_min = Math.floor(this.data_min / mag) * mag;
                    this.plot_max = Math.ceil(this.data_max / mag) * mag;
                    log_min = Math.log(this.plot_min) / this.log10;
                    log_max = Math.log(this.plot_max) / this.log10;
                    this.labels = new AxisLabel[this.nDivisions];
                } else {
                    this.plot_min = this.data_min;
                    this.plot_max = this.data_max;
                    double lastLabel = Math.ceil(Math.pow(10.0, log_max) / mag) * mag;
                    this.labels = lastLabel < this.data_max || this.areEqual(lastLabel, this.data_max) ? new AxisLabel[this.nDivisions] : new AxisLabel[this.nDivisions - 1];
                }
                for (int i = 0; i < this.labels.length; ++i) {
                    double labelValue = Math.ceil(Math.pow(10.0, (double)i * (log_max - log_min) / (double)(this.nDivisions - 1) + log_min) / mag) * mag;
                    this.labels[i] = new AxisLabel();
                    this.labels[i].text = format.format(labelValue);
                    this.labels[i].position = (Math.log(labelValue) / this.log10 - log_min) / (log_max - log_min);
                }
            } else {
                int j;
                int i;
                int i2;
                int power;
                this.scale_power = 0;
                int nLabels = nDecades;
                int skip = 1;
                if (this.useSuggestedRange) {
                    log_min = min_int;
                    log_max = max_int;
                    this.plot_min = Math.pow(10.0, min_int);
                    this.plot_max = Math.pow(10.0, max_int);
                } else {
                    this.plot_min = this.data_min;
                    this.plot_max = this.data_max;
                }
                if (nDecades > maxNumberOfDivisions && maxNumberOfDivisions > 1) {
                    this.tryForNewLabelsOnExpansion = true;
                    while (skip + 1 < nDecades && nDecades / skip >= maxNumberOfDivisions - 1) {
                        ++skip;
                    }
                    if (skip != 1) {
                        nLabels = nDecades / skip;
                        if (this.useSuggestedRange) {
                            int mod = (max_int - min_int) % skip;
                            if (mod != 0) {
                                this.plot_max = Math.pow(10.0, max_int += skip - mod);
                                log_max = max_int;
                            }
                            ++nLabels;
                        }
                        if (min_int + nLabels * skip <= max_int) {
                            ++nLabels;
                        }
                    }
                } else {
                    this.tryForNewLabelsOnExpansion = false;
                }
                this.nDivisions = nLabels;
                this.labels = new AxisLabel[nLabels];
                if (this.charsReq(min_int) > 5 || this.charsReq(max_int) > 5) {
                    power = min_int;
                    for (i2 = 0; i2 < nLabels; ++i2) {
                        this.labels[i2] = new AxisLabel();
                        this.labels[i2].text = "e".concat(String.valueOf(power));
                        this.labels[i2].position = ((double)power - log_min) / (log_max - log_min);
                        power += skip;
                    }
                } else if (min_int >= 0) {
                    this.b.setLength(0);
                    this.b.append('1');
                    for (int j2 = 0; j2 < min_int; ++j2) {
                        this.b.append('0');
                    }
                    for (i = 0; i < nLabels; ++i) {
                        this.labels[i] = new AxisLabel();
                        this.labels[i].text = this.b.toString();
                        this.labels[i].position = ((double)(i * skip + min_int) - log_min) / (log_max - log_min);
                        for (j = 0; j < skip; ++j) {
                            this.b.append('0');
                        }
                    }
                } else if (max_int < 0) {
                    this.b.setLength(0);
                    this.b.append("0.1");
                    for (i = max_int; i < -1; ++i) {
                        this.b.insert(2, '0');
                    }
                    for (i = nLabels - 1; i >= 0; --i) {
                        this.labels[i] = new AxisLabel();
                        this.labels[i].text = this.b.toString();
                        this.labels[i].position = ((double)(i * skip + min_int) - log_min) / (log_max - log_min);
                        for (j = 0; j < skip; ++j) {
                            this.b.insert(2, '0');
                        }
                    }
                } else {
                    power = min_int;
                    for (i2 = 0; i2 < nLabels; ++i2) {
                        int j3;
                        this.b.setLength(0);
                        if (power < 0) {
                            this.b.append("0.");
                            for (j3 = -1; j3 > power; --j3) {
                                this.b.append('0');
                            }
                            this.b.append('1');
                        } else {
                            this.b.append('1');
                            for (j3 = 0; j3 < power; ++j3) {
                                this.b.append('0');
                            }
                        }
                        this.labels[i2] = new AxisLabel();
                        this.labels[i2].text = this.b.toString();
                        this.labels[i2].position = ((double)power - log_min) / (log_max - log_min);
                        power += skip;
                    }
                }
                if (skip == 1) {
                    double minorTickBase = this.areEqual(min_int, log_min) ? this.plot_min : Math.pow(10.0, min_int - 1);
                    double initialIndex = this.plot_min / minorTickBase;
                    double initialIndex_ceil = Math.ceil(initialIndex);
                    int index = initialIndex_ceil > initialIndex ? (int)initialIndex_ceil : (int)initialIndex_ceil + 1;
                    int nMinorTicks = (max_int - min_int) * 8;
                    if (!this.useSuggestedRange) {
                        nMinorTicks += (int)((Math.pow(10.0, min_int) - this.data_min) / Math.pow(10.0, min_int - 1));
                        nMinorTicks += (int)((this.data_max - Math.pow(10.0, max_int)) / Math.pow(10.0, max_int));
                    }
                    this.minorTickPositions = new double[nMinorTicks];
                    for (int i3 = 0; i3 < nMinorTicks; ++i3) {
                        if (index > 9) {
                            index = 2;
                            minorTickBase *= 10.0;
                        }
                        this.minorTickPositions[i3] = (Math.log((double)index * minorTickBase) / this.log10 - log_min) / (log_max - log_min);
                        ++index;
                    }
                } else {
                    this.minorTickPositions = null;
                    for (int nMinorDivisions = Math.min(6, skip); nMinorDivisions > 1; --nMinorDivisions) {
                        if (skip % nMinorDivisions != 0) continue;
                        int minorSkip = skip / nMinorDivisions;
                        int nMinorTicks = (nMinorDivisions - 1) * (max_int - min_int) / skip;
                        int tickPower = min_int + minorSkip;
                        this.minorTickPositions = new double[nMinorTicks];
                        for (int i4 = 0; i4 < nMinorTicks; ++i4) {
                            if ((tickPower - min_int) % skip == 0) {
                                tickPower += minorSkip;
                            }
                            this.minorTickPositions[i4] = ((double)tickPower - log_min) / (log_max - log_min);
                            tickPower += minorSkip;
                        }
                        break;
                    }
                }
            }
        } else {
            double inc;
            int nDivisions;
            this.tryForNewLabelsOnExpansion = true;
            this.minorTickPositions = null;
            double difference = this.data_max - this.data_min;
            double pow = Math.floor(Math.log(difference) / this.log10) - 1.0;
            int fractDigits = 0;
            if (this.scale_power > 0) {
                fractDigits = this.scale_power - (int)pow;
            } else if (pow < -0.5) {
                fractDigits = this.scale_power - (int)pow;
            }
            double conversion = Math.pow(10.0, pow);
            int intMin = this.round(this.data_min / conversion, this.useSuggestedRange);
            int intMax = this.round(this.data_max / conversion, !this.useSuggestedRange);
            if (this.useSuggestedRange) {
                this.plot_min = (double)intMin * conversion;
                this.plot_max = (double)intMax * conversion;
            } else {
                this.plot_min = this.data_min;
                this.plot_max = this.data_max;
            }
            int naturalNumberOfDivisions = intMax - intMin;
            float idealMinFraction = 0.5f;
            int nUnits = 1;
            if (naturalNumberOfDivisions < maxNumberOfDivisions) {
                float proximity = (float)naturalNumberOfDivisions / (float)maxNumberOfDivisions;
                boolean niceDivisionFound = false;
                if (proximity < 0.5f) {
                    int candidate;
                    int[] divisions = new int[]{2, 4, 5, 10, 20};
                    for (int i = 0; i < divisions.length && (double)(proximity * (float)(candidate = divisions[i])) <= 1.0; ++i) {
                        niceDivisionFound = true;
                        nUnits = candidate;
                    }
                }
                if (niceDivisionFound) {
                    nDivisions = this.useSuggestedRange ? naturalNumberOfDivisions * nUnits : naturalNumberOfDivisions * nUnits + (int)((this.plot_max / conversion - (double)intMax) * (double)nUnits);
                    if (pow < 0.5 || this.scale_power > 0) {
                        ++fractDigits;
                    }
                    if (!(nUnits != 4 && nUnits != 20 || !(pow < 1.5) && this.scale_power <= 0)) {
                        ++fractDigits;
                    }
                } else {
                    nDivisions = Math.max(naturalNumberOfDivisions, 1);
                }
            } else if (naturalNumberOfDivisions > maxNumberOfDivisions) {
                nDivisions = 1;
                int[] skips = new int[]{2, 5, 10, 20, 25, 50};
                for (int i = 0; i < skips.length; ++i) {
                    int nDivisionsThisTry = naturalNumberOfDivisions / skips[i];
                    if (nDivisionsThisTry > maxNumberOfDivisions) continue;
                    nUnits = skips[i];
                    nDivisions = nDivisionsThisTry;
                    if (this.useSuggestedRange) {
                        boolean changed = false;
                        if (intMin % nUnits != 0) {
                            intMin -= intMin % nUnits;
                            this.plot_min = (double)intMin * conversion;
                            changed = true;
                        }
                        if (intMax % nUnits != 0) {
                            intMax += nUnits - intMax % nUnits;
                            this.plot_max = (double)intMax * conversion;
                            changed = true;
                        }
                        if (changed) {
                            nDivisions = (intMax - intMin) / nUnits;
                        }
                    }
                    if (nUnits >= 10 && nUnits != 25 && fractDigits > 0) {
                        --fractDigits;
                    }
                    if (intMin % nUnits != 0) {
                        int increase;
                        int n = increase = intMin > 0 ? nUnits - intMin % nUnits : -intMin % nUnits;
                        if (increase > intMax - (intMax - intMin) / nUnits * nUnits - intMin) {
                            --nDivisions;
                        }
                        intMin += increase;
                    }
                    break;
                }
            } else {
                nDivisions = Math.max(naturalNumberOfDivisions, 1);
            }
            double minLabelValue = (double)intMin * conversion;
            double d = inc = naturalNumberOfDivisions < maxNumberOfDivisions ? conversion / (double)nUnits : conversion * (double)nUnits;
            if (naturalNumberOfDivisions < maxNumberOfDivisions && minLabelValue - inc >= this.plot_min) {
                int nLost = (int)((minLabelValue - this.plot_min) / inc);
                minLabelValue -= (double)nLost * inc;
                nDivisions += nLost;
            }
            if (nDivisions < 0) {
                nDivisions = 0;
            }
            if (nDivisions > maxNumberOfDivisions) {
                nDivisions = maxNumberOfDivisions;
            }
            this.labels = new AxisLabel[nDivisions + 1];
            this.nDivisions = nDivisions;
            format.setFractionDigits(fractDigits);
            for (int j = 0; j < this.labels.length; ++j) {
                double labelValue = minLabelValue + (double)j * inc;
                this.labels[j] = new AxisLabel();
                this.labels[j].text = format.format(labelValue);
                this.labels[j].position = (labelValue - this.plot_min) / (this.plot_max - this.plot_min);
            }
        }
    }

    private int calculateMaxNDivisions(FontMetrics fm, int axisLength) {
        int result = this.axis.getAxisOrientation() == 2 ? axisLength / (fm.charWidth('5') * 5 + 3) : axisLength / (fm.getHeight() + 3);
        return Math.max(1, result);
    }

    private int getPowerOffset(FontMetrics fm) {
        return fm.getAscent() / 2;
    }

    @Override
    void assumeAxisLength(int axisLength) {
        Font font = this.axis.getFont();
        FontMetrics fm = this.axis.getToolkit().getFontMetrics(font);
        int maxNumberOfDivisions = this.calculateMaxNDivisions(fm, axisLength);
        if (!this.labelsValid || this.labels == null || this.nDivisions < 2 || this.nDivisions > maxNumberOfDivisions || this.tryForNewLabelsOnExpansion && this.nDivisions < maxNumberOfDivisions / 2) {
            this.createNewLabels(maxNumberOfDivisions);
        }
        this.hideMinorTicks = this.minorTickPositions == null || this.nDivisions > maxNumberOfDivisions / 3;
        int lastLabelLocation = (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)axisLength);
        if (this.axis.getAxisOrientation() == 1) {
            this.spaceRequirements.width = this.longestStringLength(fm, this.labels) + 7;
            this.spaceRequirements.flowPastEnd = fm.getMaxAscent() - fm.getAscent() / 2 - lastLabelLocation;
            if (this.logarithmic && this.labels[0].text.startsWith("e")) {
                this.spaceRequirements.width += fm.stringWidth("10") - fm.charWidth('e');
                this.spaceRequirements.flowPastEnd += fm.getHeight() / 2;
            }
            if (this.scale_power != 0) {
                this.spaceRequirements.width = Math.max(fm.stringWidth("x10") + fm.stringWidth(String.valueOf(this.scale_power)), this.spaceRequirements.width);
                this.spaceRequirements.flowPastEnd += 3;
                if (this.spaceRequirements.flowPastEnd < 0) {
                    this.spaceRequirements.flowPastEnd = 0;
                }
                this.spaceRequirements.flowPastEnd += fm.getAscent();
            } else if (this.spaceRequirements.flowPastEnd < 0) {
                this.spaceRequirements.flowPastEnd = 0;
            }
            int lineHeight = this.isLogarithmic() && this.labels[0].text.startsWith("e") ? fm.getHeight() / 2 + fm.getAscent() : fm.getAscent();
            this.spaceRequirements.height = Math.max(lineHeight / 2 - (int)(this.labels[0].position * (double)axisLength), 0);
        } else {
            this.spaceRequirements.width = Math.max(this.stringWidth(fm, this.labels[0].text) / 2 - (int)(this.labels[0].position * (double)axisLength), 0);
            this.spaceRequirements.flowPastEnd = this.stringWidth(fm, this.labels[this.labels.length - 1].text) / 2 - lastLabelLocation;
            int lineHeight = this.isLogarithmic() && this.labels[0].text.startsWith("e") ? fm.getHeight() / 2 + fm.getMaxAscent() + fm.getDescent() : fm.getMaxAscent() + fm.getDescent();
            this.spaceRequirements.height = lineHeight + 7;
            if (this.scale_power != 0) {
                this.spaceRequirements.height = Math.max(fm.getHeight() / 2 + fm.getAscent() + this.getPowerOffset(fm), this.spaceRequirements.height);
                this.spaceRequirements.flowPastEnd += 3;
                if (this.spaceRequirements.flowPastEnd < 0) {
                    this.spaceRequirements.flowPastEnd = 0;
                }
                this.spaceRequirements.flowPastEnd += fm.stringWidth("x10") + fm.stringWidth(String.valueOf(this.scale_power));
            } else if (this.spaceRequirements.flowPastEnd < 0) {
                this.spaceRequirements.flowPastEnd = 0;
            }
        }
    }

    @Override
    public CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    @Override
    void paintAxis(PlotGraphics g, double originX, double originY, double length, Color textColor, Color majorTickColor, Color minorTickColor) {
        block18: {
            boolean isHorizontal = this.axis.getAxisOrientation() == 2;
            boolean onLeft = !isHorizontal && this.axis.onLeftSide;
            double minL = isHorizontal ? originX : originY;
            double maxL = isHorizontal ? originX + length : originY - length;
            FontMetrics fm = g.getFontMetrics();
            int lineHeight = fm.getHeight();
            int ascent = fm.getAscent();
            int maxAscent = fm.getMaxAscent();
            double lastLabel = 0.0;
            if (this.labels == null) {
                return;
            }
            if (this.logarithmic) {
                boolean isInExp = this.labels[0].text.startsWith("e");
                for (int i = 0; i < this.labels.length; ++i) {
                    double textLength;
                    String text = this.labels[i].text;
                    String pow = null;
                    if (isInExp) {
                        pow = text.substring(1);
                        text = "10";
                        textLength = fm.stringWidth(text) + fm.stringWidth(pow);
                    } else {
                        textLength = fm.stringWidth(text);
                    }
                    double pos = minL + (double)((int)(this.labels[i].position * (maxL - minL)));
                    if (isHorizontal) {
                        g.setColor(majorTickColor);
                        g.drawLine(pos, originY + 5.0, pos, originY - 5.0);
                        double y = originY + (double)maxAscent + 7.0;
                        pos -= textLength / 2.0;
                        g.setColor(textColor);
                        if (isInExp) {
                            g.drawString(pow, pos + (double)fm.stringWidth(text), y);
                            y += (double)(lineHeight / 2);
                        }
                        g.drawString(text, pos, y);
                        continue;
                    }
                    g.setColor(majorTickColor);
                    g.drawLine(originX - 5.0, pos, originX + 5.0, pos);
                    double x = onLeft ? originX - textLength - 7.0 : originX + 7.0;
                    pos += (double)(ascent / 2);
                    g.setColor(textColor);
                    if (isInExp) {
                        g.drawString(pow, x + (double)fm.stringWidth(text), pos - (double)(lineHeight / 2));
                    }
                    g.drawString(text, x, pos);
                }
            } else {
                for (int i = 0; i < this.labels.length; ++i) {
                    String text = this.labels[i].text;
                    double pos = minL + this.labels[i].position * (maxL - minL);
                    if (isHorizontal) {
                        g.setColor(majorTickColor);
                        g.drawLine(pos, originY + 5.0, pos, originY - 5.0);
                        double y = originY + (double)maxAscent + 7.0;
                        g.setColor(textColor);
                        g.drawString(text, pos - (double)(fm.stringWidth(text) / 2), y);
                        continue;
                    }
                    g.setColor(majorTickColor);
                    g.drawLine(originX - 5.0, pos, originX + 5.0, pos);
                    double x = onLeft ? originX - (double)fm.stringWidth(text) - 7.0 : originX + 7.0;
                    g.setColor(textColor);
                    g.drawString(text, x, pos + (double)(ascent / 2));
                }
                lastLabel = minL + this.labels[this.labels.length - 1].position * (maxL - minL);
            }
            if (this.scale_power != 0) {
                g.setColor(textColor);
                String s = String.valueOf(this.scale_power);
                if (isHorizontal) {
                    double y = originY + (double)ascent + (double)this.getPowerOffset(fm) + 2.0;
                    double x = this.axis.getSize().width - 3 - fm.stringWidth(s) + this.spaceRequirements.flowPastEnd;
                    g.drawString("x10", x - (double)fm.stringWidth("x10"), y + (double)(lineHeight / 2));
                    g.drawString(s, x, y + (double)(lineHeight / 5));
                } else {
                    double y = lineHeight / 2;
                    double x = onLeft ? originX - (double)fm.stringWidth(s) : originX;
                    g.drawString("x10", onLeft ? x - (double)fm.stringWidth("x10") : x, y + (double)(lineHeight / 2));
                    g.drawString(s, onLeft ? x : x + (double)fm.stringWidth("x10"), y + (double)(lineHeight / 5));
                }
            }
            if (this.hideMinorTicks || this.minorTickPositions == null || this.minorTickPositions.length == 0) break block18;
            g.setColor(minorTickColor);
            if (isHorizontal) {
                for (int i = 0; i < this.minorTickPositions.length; ++i) {
                    double x = minL + (double)((int)(this.minorTickPositions[i] * (maxL - minL)));
                    g.drawLine(x, originY + 3.0, x, originY - 3.0);
                }
            } else {
                for (int i = 0; i < this.minorTickPositions.length; ++i) {
                    double y = minL + (double)((int)(this.minorTickPositions[i] * (maxL - minL)));
                    g.drawLine(originX - 3.0, y, originX + 3.0, y);
                }
            }
        }
    }

    @Override
    int getMajorTickMarkLength() {
        return 5;
    }

    @Override
    public double convert(double d) {
        int minL = this.axis.getMinLocation();
        int maxL = this.axis.getMaxLocation();
        if (this.logarithmic) {
            double min = Math.log(this.plot_min) / this.log10;
            double max = Math.log(this.plot_max) / this.log10;
            d = d > 0.0 ? Math.log(d) / this.log10 : min;
            double f = (d - min) / (max - min);
            return (double)minL + f * (double)(maxL - minL);
        }
        double f = (d - this.plot_min) / (this.plot_max - this.plot_min);
        return (double)minL + f * (double)(maxL - minL);
    }

    @Override
    public double unConvert(double d) {
        int minL = this.axis.getMinLocation();
        int maxL = this.axis.getMaxLocation();
        double f = (d - (double)minL) / (double)(maxL - minL);
        if (this.logarithmic) {
            double min = Math.log(this.plot_min) / this.log10;
            double max = Math.log(this.plot_max) / this.log10;
            return this.plot_min + f * (max - min);
        }
        return this.plot_min + f * (this.plot_max - this.plot_min);
    }

    public double getIntersection() {
        return this.plot_min;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.logarithmic);
        out.writeBoolean(this.useSuggestedRange);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.logarithmic = in.readBoolean();
        this.useSuggestedRange = in.readBoolean();
    }
}

