/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestRebBulkPS
extends TestSrp {
    static final Map<Integer, String> ioBitsMap = new LinkedHashMap<Integer, String>();
    static final Map<Integer, String> statBitsMap;
    private final RebBulkPS bulk;

    public TestRebBulkPS() {
        super(new RebBulkPS());
        this.bulk = (RebBulkPS)this.srp;
    }

    @Command(description="Read the board temperature")
    public double readBoardTemp() throws DriverException {
        return this.bulk.readBoardTemperature();
    }

    @Command(description="Turn a PS on or off")
    public void setPower(@Argument(description="Power supply ID") int id, @Argument(description="Whether to turn on") TestSrp.OnOff on) throws DriverException {
        this.bulk.setPowerOn(id, on == TestSrp.OnOff.ON);
    }

    @Command(description="Show a PS I/O status word")
    public String showIoStatus(@Argument(description="Power supply ID") int id) throws DriverException {
        int status = this.bulk.getIoStatus(id);
        return String.format("0x%02x %s", status, TestRebBulkPS.genBitNames(status, ioBitsMap));
    }

    @Command(description="Show a PS model type")
    public int showModel(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getModel(id);
    }

    @Command(description="Show a PS serial number")
    public String showSerial(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getSerialNo(id);
    }

    @Command(description="Show a PS firmware version")
    public String showFwVersion(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getFwVersion(id);
    }

    @Command(description="Show a PS product version")
    public String showPrVersion(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getPrVersion(id);
    }

    @Command(description="Show a PS part number")
    public String showPartNo(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getPartNo(id);
    }

    @Command(description="Show a PS manufacture date")
    public String showManuDate(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getManuDate(id);
    }

    @Command(description="Show a PS manufacture location")
    public String showManuLocn(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.getManuLocn(id);
    }

    @Command(description="Read a PS status word")
    public String readStatus(@Argument(description="Power supply ID") int id) throws DriverException {
        int status = this.bulk.readStatus(id);
        return String.format("0x%02x %s", status, TestRebBulkPS.genBitNames(status, statBitsMap));
    }

    @Command(description="Read a PS voltage")
    public double readVoltage(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.readVoltage(id);
    }

    @Command(description="Read a PS current")
    public double readCurrent(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.readCurrent(id);
    }

    @Command(description="Read a PS temperature")
    public double readTemp(@Argument(description="Power supply ID") int id) throws DriverException {
        return this.bulk.readTemperature(id);
    }

    static String genBitNames(int value, Map<Integer, String> bitsMap) {
        StringBuilder text = new StringBuilder();
        String prefix = "(";
        for (int mask : bitsMap.keySet()) {
            if ((mask & value) == 0) continue;
            text.append(prefix).append(bitsMap.get(mask));
            prefix = ", ";
        }
        if (text.length() != 0) {
            text.append(")");
        }
        return text.toString();
    }

    static {
        ioBitsMap.put(1, "rem-on");
        ioBitsMap.put(2, "enab");
        ioBitsMap.put(4, "ac-ok");
        ioBitsMap.put(8, "pwr-ok");
        ioBitsMap.put(16, "otw");
        statBitsMap = new LinkedHashMap<Integer, String>();
        statBitsMap.put(1, "off");
        statBitsMap.put(2, "dsab");
        statBitsMap.put(4, "iogb");
        statBitsMap.put(8, "otw");
        statBitsMap.put(16, "otp");
        statBitsMap.put(32, "vbad");
        statBitsMap.put(64, "ibad");
    }
}

