/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.classname.ClassComponentNodeFactory;
import org.lsst.ccs.description.groovy.GroovyComponentNodeFactory;

public class ComponentNodeBuilder {
    private static final HashMap<String, ComponentNodeFactory> factories = new HashMap();

    private ComponentNodeBuilder() {
    }

    public static void registerComponentNodeFactory(ComponentNodeFactory factory) {
        factories.put(factory.getProtocol(), factory);
    }

    public static ComponentLookup buildComponentNode(String fullDescription) {
        return ComponentNodeBuilder.buildComponentNode(fullDescription, null, new Properties());
    }

    public static ComponentLookup buildComponentNode(String fullDescription, String startupConfig, Properties props) {
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        buildArgs.put("startupConfig", startupConfig);
        buildArgs.put("descriptionName", fullDescription);
        return ComponentNodeBuilder.buildComponentNode(buildArgs, props);
    }

    public static ComponentLookup buildComponentNode(Map<String, String> buildArgs, Properties props) {
        ComponentNodeFactory factory;
        String descriptionProtocol = "groovy";
        String descriptionString = buildArgs.get("descriptionName");
        if (descriptionString.contains(":")) {
            descriptionProtocol = descriptionString.substring(0, descriptionString.indexOf(58));
            descriptionString = descriptionString.substring(descriptionString.indexOf(58) + 1);
            buildArgs.put("descriptionName", descriptionString);
        }
        if ((factory = factories.get(descriptionProtocol)) == null) {
            throw new IllegalArgumentException("There is no registered ComponentNodeFactory for protocol " + descriptionProtocol);
        }
        ComponentLookup lookup = factory.buildComponentNode(descriptionString, props);
        for (Map.Entry<String, String> e : buildArgs.entrySet()) {
            lookup.getTopComponentNode().addTag(e.getKey(), e.getValue());
        }
        return lookup;
    }

    static {
        ComponentNodeBuilder.registerComponentNodeFactory(new GroovyComponentNodeFactory());
        ComponentNodeBuilder.registerComponentNodeFactory(new ClassComponentNodeFactory());
    }

    public static interface ComponentNodeFactory {
        public ComponentLookup buildComponentNode(String var1, Properties var2);

        public String getProtocol();
    }
}

