/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.alerts;

import org.lsst.ccs.bus.data.Alert;

public enum InfrastructureAlert {
    PERIODIC_TASK_BEHIND("PeriodicTaskBehind", "Alert raised when a periodic task falls behind."),
    PERIODIC_TASK_FAILURE("PeriodicTaskFailure", "Alert raised when periodic tasks have failures (exceptions) during execution. At ALARM level the task execution is terminated."),
    PERIODIC_TASK_SKIPPED("PeriodicTaskSkipped", "Alert raised when periodic task executions are skipped."),
    STATE_MISMATCH("StateMismatch", "Alert raised when the internal state is inconsistent with the actual state"),
    REQUESTED_STATE_PUBLICATION("RequestedStatePublication", "Alert raised when a command request to publish a state message has been issued.");

    private final String id;
    private final String description;

    private InfrastructureAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return new Alert(this.id, this.description);
    }
}

