/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.table;

import java.util.Comparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freehep.swing.table.SortableTableModel;

public class DefaultSortableTableModel
implements SortableTableModel {
    private Comparator comparator = new DefaultComparator();
    private TableModel source;
    private EventListenerList listeners = new EventListenerList();
    private TableModelListener internalListener = new InternalTableModelListener();
    private int sortColumn = -1;
    private boolean ascending = true;
    private int[] rowMap;
    private int[] reverseMap;
    boolean reverseMapValid = false;
    private int nRows;

    public DefaultSortableTableModel(TableModel source) {
        this.source = source;
    }

    private int mapFromSorted(int rowIndex) {
        return this.rowMap == null ? rowIndex : this.rowMap[rowIndex];
    }

    private int mapToSorted(int rowIndex) {
        if (this.rowMap != null && !this.reverseMapValid) {
            if (this.reverseMap == null || this.reverseMap.length < this.nRows) {
                this.reverseMap = new int[this.rowMap.length];
            }
            for (int i = 0; i < this.nRows; ++i) {
                this.reverseMap[this.rowMap[i]] = i;
            }
            this.reverseMapValid = true;
        }
        return this.rowMap == null ? rowIndex : this.reverseMap[rowIndex];
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners.getListenerCount() == 0) {
            this.dataChanged();
            this.source.addTableModelListener(this.internalListener);
        }
        this.listeners.add(TableModelListener.class, l);
    }

    public Class getColumnClass(int columnIndex) {
        return this.source.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.source.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.source.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.source.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.source.getValueAt(this.mapFromSorted(rowIndex), columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.source.isCellEditable(this.mapFromSorted(rowIndex), columnIndex);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(TableModelListener.class, l);
        if (this.listeners.getListenerCount() == 0) {
            this.source.removeTableModelListener(this.internalListener);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.source.setValueAt(aValue, this.mapFromSorted(rowIndex), columnIndex);
    }

    @Override
    public void sort(int column, boolean ascending) {
        if (column == -1) {
            if (this.sortColumn != -1) {
                this.rowMap = null;
                this.reverseMap = null;
                this.reverseMapValid = false;
                this.sortColumn = column;
                TableModelEvent ee = new TableModelEvent(this, 0, this.source.getRowCount() - 1, -1);
                this.fireTableChanged(ee);
            }
        } else if (column == this.sortColumn) {
            if (ascending != this.ascending) {
                this.ascending = ascending;
                for (int i = 0; i < this.nRows / 2; ++i) {
                    this.swap(i, this.nRows - 1 - i);
                }
                this.reverseMapValid = false;
                TableModelEvent ee = new TableModelEvent(this, 0, this.nRows - 1, -1);
                this.fireTableChanged(ee);
            }
        } else {
            if (this.rowMap == null) {
                this.nRows = this.source.getRowCount();
                this.rowMap = new int[this.nRows + 10];
                for (int i = 0; i < this.nRows; ++i) {
                    this.rowMap[i] = i;
                }
            }
            this.sortColumn = column;
            this.ascending = ascending;
            this.reverseMapValid = false;
            this.sort1(0, this.nRows);
            TableModelEvent ee = new TableModelEvent(this, 0, this.nRows - 1, -1);
            this.fireTableChanged(ee);
        }
    }

    private void reSort() {
        this.reverseMapValid = false;
        this.sort1(0, this.nRows);
        TableModelEvent ee = new TableModelEvent(this, 0, this.nRows - 1, -1);
        this.fireTableChanged(ee);
    }

    private void dataChanged() {
        this.nRows = this.source.getRowCount();
        this.rowMap = new int[this.nRows + 10];
        for (int i = 0; i < this.nRows; ++i) {
            this.rowMap[i] = i;
        }
        this.reverseMapValid = false;
        if (this.sortColumn != -1) {
            this.sort1(0, this.nRows);
        }
        TableModelEvent ee = new TableModelEvent(this, 0, Integer.MAX_VALUE, -1);
        this.fireTableChanged(ee);
    }

    private int rowWasInserted(int row) {
        if (this.nRows == this.rowMap.length) {
            int[] newMap = new int[this.rowMap.length + 10];
            System.arraycopy(this.rowMap, 0, newMap, 0, this.rowMap.length);
            this.rowMap = newMap;
        }
        for (int i = 0; i < this.nRows; ++i) {
            if (this.rowMap[i] < row) continue;
            int n = i;
            this.rowMap[n] = this.rowMap[n] + 1;
        }
        this.rowMap[this.nRows] = row;
        int insertPoint = this.binarySearch(this.nRows, 0, this.nRows);
        if (insertPoint != this.nRows) {
            System.arraycopy(this.rowMap, insertPoint, this.rowMap, insertPoint + 1, this.nRows - insertPoint);
            this.rowMap[insertPoint] = row;
        }
        ++this.nRows;
        this.reverseMapValid = false;
        return insertPoint;
    }

    private int binarySearch(int newRow, int start, int end) {
        if (start - end < 5) {
            for (int i = start; i < end; ++i) {
                if (this.compare(newRow, i) > 0) continue;
                return i;
            }
            return end;
        }
        int mid = end - start >> 1;
        int result = this.compare(newRow, mid);
        if (result == 0) {
            return mid;
        }
        if (result > 0) {
            return this.binarySearch(newRow, mid, end);
        }
        return this.binarySearch(newRow, start, mid);
    }

    private int rowWasDeleted(int row) {
        int sortedRow = this.mapToSorted(row);
        System.arraycopy(this.rowMap, sortedRow + 1, this.rowMap, sortedRow, this.nRows - sortedRow - 1);
        --this.nRows;
        for (int i = 0; i < this.nRows; ++i) {
            if (this.rowMap[i] <= row) continue;
            int n = i;
            this.rowMap[n] = this.rowMap[n] - 1;
        }
        this.reverseMapValid = false;
        return sortedRow;
    }

    private Object get(int index) {
        return this.source.getValueAt(this.rowMap[index], this.sortColumn);
    }

    private int compare(int i, int j) {
        return this.comparator.compare(this.get(i), this.get(j)) * (this.ascending ? 1 : -1);
    }

    private int compare(Object o, int j) {
        return this.comparator.compare(o, this.get(j)) * (this.ascending ? 1 : -1);
    }

    private void swap(int i, int j) {
        int tmp = this.rowMap[i];
        this.rowMap[i] = this.rowMap[j];
        this.rowMap[j] = tmp;
    }

    private int med3(int a, int b, int c) {
        return this.compare(a, b) < 0 ? (this.compare(b, c) < 0 ? b : (this.compare(a, c) < 0 ? c : a)) : (this.compare(b, c) > 0 ? b : (this.compare(a, c) > 0 ? c : a));
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j) > 0; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        Object v = this.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = this.compare(v, b)) >= 0) {
                if (comp == 0) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = this.compare(v, c)) <= 0) {
                if (comp == 0) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    protected void fireTableChanged(TableModelEvent event) {
        TableModelListener[] l = (TableModelListener[])this.listeners.getListeners(TableModelListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].tableChanged(event);
        }
    }

    @Override
    public boolean isSortAscending() {
        return this.ascending;
    }

    @Override
    public int getSortOnColumn() {
        return this.sortColumn;
    }

    private class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo((Comparable)o2);
            }
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
    }

    private class InternalTableModelListener
    implements TableModelListener {
        private InternalTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            int first = e.getFirstRow();
            int last = e.getLastRow();
            int type = e.getType();
            if (DefaultSortableTableModel.this.sortColumn == -1) {
                TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, first, last, column, type);
                DefaultSortableTableModel.this.fireTableChanged(ee);
            } else if (first == -1) {
                if (type == -1) {
                    if (column < DefaultSortableTableModel.this.sortColumn) {
                        DefaultSortableTableModel.this.sortColumn--;
                    } else if (column == DefaultSortableTableModel.this.sortColumn) {
                        DefaultSortableTableModel.this.sort(-1, true);
                    }
                } else if (type == 1) {
                    if (column <= DefaultSortableTableModel.this.sortColumn && DefaultSortableTableModel.this.sortColumn != -1) {
                        DefaultSortableTableModel.this.sortColumn++;
                    }
                } else if (type == 0 && (column == DefaultSortableTableModel.this.sortColumn || column == -1)) {
                    DefaultSortableTableModel.this.reSort();
                }
                TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, first, last, column, type);
                DefaultSortableTableModel.this.fireTableChanged(ee);
            } else if (column == -1) {
                if (type == -1) {
                    for (int i = first; i <= last; ++i) {
                        int sortedRow = DefaultSortableTableModel.this.rowWasDeleted(first);
                        TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, sortedRow, sortedRow, column, type);
                        DefaultSortableTableModel.this.fireTableChanged(ee);
                    }
                } else if (type == 1) {
                    for (int i = first; i <= last; ++i) {
                        int sortedRow = DefaultSortableTableModel.this.rowWasInserted(i);
                        TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, sortedRow, sortedRow, column, type);
                        DefaultSortableTableModel.this.fireTableChanged(ee);
                    }
                } else if (type == 0) {
                    if (Integer.MAX_VALUE == last) {
                        DefaultSortableTableModel.this.dataChanged();
                    } else {
                        for (int i = first; i <= last; ++i) {
                            int newRow;
                            int oldRow = DefaultSortableTableModel.this.rowWasDeleted(i);
                            if (oldRow == (newRow = DefaultSortableTableModel.this.rowWasInserted(i))) {
                                TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, newRow, newRow, column, type);
                                DefaultSortableTableModel.this.fireTableChanged(ee);
                                continue;
                            }
                            TableModelEvent ee1 = new TableModelEvent(DefaultSortableTableModel.this, oldRow, oldRow, -1, -1);
                            DefaultSortableTableModel.this.fireTableChanged(ee1);
                            TableModelEvent ee2 = new TableModelEvent(DefaultSortableTableModel.this, newRow, newRow, -1, 1);
                            DefaultSortableTableModel.this.fireTableChanged(ee2);
                        }
                    }
                }
            } else if (type == 0) {
                if (column == DefaultSortableTableModel.this.sortColumn) {
                    for (int i = first; i <= last; ++i) {
                        int newRow;
                        int oldRow = DefaultSortableTableModel.this.rowWasDeleted(i);
                        if (oldRow == (newRow = DefaultSortableTableModel.this.rowWasInserted(i))) {
                            TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, newRow, newRow, column, type);
                            DefaultSortableTableModel.this.fireTableChanged(ee);
                            continue;
                        }
                        TableModelEvent ee1 = new TableModelEvent(DefaultSortableTableModel.this, oldRow, oldRow, -1, -1);
                        DefaultSortableTableModel.this.fireTableChanged(ee1);
                        TableModelEvent ee2 = new TableModelEvent(DefaultSortableTableModel.this, newRow, newRow, -1, 1);
                        DefaultSortableTableModel.this.fireTableChanged(ee2);
                    }
                } else {
                    for (int i = first; i <= last; ++i) {
                        int sortedRow = DefaultSortableTableModel.this.mapToSorted(i);
                        TableModelEvent ee = new TableModelEvent(DefaultSortableTableModel.this, sortedRow, sortedRow, column, type);
                        DefaultSortableTableModel.this.fireTableChanged(ee);
                    }
                }
            } else {
                throw new UnsupportedOperationException("An unsupported TableModelEvent was found: " + e);
            }
        }
    }
}

