/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.mock;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.lsst.ccs.messaging.mock.CommandFor;
import org.lsst.ccs.messaging.mock.PackCst;

class ParallelCommandDispatcher<T> {
    private final ExecutorService loop;
    private final CopyOnWriteArrayList<T> list = new CopyOnWriteArrayList();

    ParallelCommandDispatcher() {
        this.loop = PackCst.EXECUTOR_SERVICE;
    }

    ParallelCommandDispatcher(ExecutorService execService) {
        this.loop = execService;
    }

    ParallelCommandDispatcher(boolean singleThread) {
        this.loop = singleThread ? PackCst.SINGLE_THREAD : PackCst.EXECUTOR_SERVICE;
    }

    void addExecutant(T executant) {
        this.list.add(executant);
    }

    void removeExecutant(T executant) {
        this.list.remove(executant);
    }

    void dispatchCommand(CommandFor<T> command) {
        for (T executant : this.list) {
            this.loop.submit(new DoIt<T>(executant, command));
        }
    }

    static class DoIt<T2>
    implements Runnable {
        public final T2 executant;
        public final CommandFor<T2> command;

        DoIt(T2 executant, CommandFor<T2> command) {
            this.executant = executant;
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.invokeOn(this.executant);
            }
            catch (Exception exc) {
                PackCst.CURLOG.log(Level.SEVERE, "while executing :", exc);
            }
        }
    }
}

