/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.bus;

import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.bus.AlarmBusMessage;
import org.lsst.ccs.messaging.bus.BaseBusMessage;
import org.lsst.ccs.messaging.bus.StatusBusMessage;
import org.lsst.ccs.messaging.bus.SuperAlarmBusMessage;

public class TestBusMessageFilter {
    @Test
    public void testBasicFiltering() {
        BaseBusMessage busMessage = new BaseBusMessage("This is the summary: temp");
        busMessage.setOriginAgentInfo(new AgentInfo("someOrigin", AgentInfo.AgentType.CONSOLE));
        AlarmBusMessage alarmMessage = new AlarmBusMessage("[ALARM] out of value: temp");
        alarmMessage.setOriginAgentInfo(new AgentInfo("someOtherOrigin", AgentInfo.AgentType.CONSOLE));
        SuperAlarmBusMessage superAlarmMessage = new SuperAlarmBusMessage("[ALARM] really out of value: temp");
        superAlarmMessage.setOriginAgentInfo(new AgentInfo("somewhereElseOrigin", AgentInfo.AgentType.CONSOLE));
        StatusBusMessage statusMessage = new StatusBusMessage("[STATUS] ");
        statusMessage.setOriginAgentInfo(new AgentInfo("ccc", AgentInfo.AgentType.CONSOLE));
        Predicate originFilter = BusMessageFilterFactory.messageOrigin((String)"someOrigin");
        Predicate otherOriginFilter = BusMessageFilterFactory.messageOrigin((String)"someOtherOrigin");
        Predicate<BaseBusMessage> notOtherOriginFilter = otherOriginFilter.negate();
        Assert.assertTrue((boolean)originFilter.test(busMessage));
        Assert.assertTrue((boolean)otherOriginFilter.test(alarmMessage));
        Assert.assertFalse((boolean)otherOriginFilter.test(busMessage));
        Assert.assertTrue((boolean)notOtherOriginFilter.test(busMessage));
        Predicate busMessageFilter = BusMessageFilterFactory.messageClass(BaseBusMessage.class);
        Predicate alarmMessageFilter = BusMessageFilterFactory.messageClass(AlarmBusMessage.class);
        Predicate superAlarmMessageFilter = BusMessageFilterFactory.messageClass(SuperAlarmBusMessage.class);
        Predicate statusMessageFilter = BusMessageFilterFactory.messageClass(StatusBusMessage.class);
        Assert.assertTrue((boolean)busMessageFilter.test(busMessage));
        Assert.assertTrue((boolean)busMessageFilter.test(alarmMessage));
        Assert.assertTrue((boolean)busMessageFilter.test(superAlarmMessage));
        Assert.assertTrue((boolean)busMessageFilter.test(statusMessage));
        Assert.assertFalse((boolean)alarmMessageFilter.test(busMessage));
        Assert.assertTrue((boolean)alarmMessageFilter.test(alarmMessage));
        Assert.assertTrue((boolean)alarmMessageFilter.test(superAlarmMessage));
        Assert.assertFalse((boolean)alarmMessageFilter.test(statusMessage));
        Assert.assertFalse((boolean)superAlarmMessageFilter.test(busMessage));
        Assert.assertFalse((boolean)superAlarmMessageFilter.test(alarmMessage));
        Assert.assertTrue((boolean)superAlarmMessageFilter.test(superAlarmMessage));
        Assert.assertFalse((boolean)superAlarmMessageFilter.test(statusMessage));
        Assert.assertFalse((boolean)statusMessageFilter.test(busMessage));
        Assert.assertFalse((boolean)statusMessageFilter.test(alarmMessage));
        Assert.assertFalse((boolean)statusMessageFilter.test(superAlarmMessage));
        Assert.assertTrue((boolean)statusMessageFilter.test(statusMessage));
        String summaryFilter = "temp";
        Predicate<BusMessage> summaryfilter = busMessage1 -> {
            if (busMessage1 instanceof BaseBusMessage) {
                return ((BaseBusMessage)((Object)busMessage1)).getSummary().contains(summaryFilter);
            }
            return false;
        };
        Predicate<BusMessage> notTempSummaryFilter = summaryfilter.negate();
        Assert.assertTrue((boolean)summaryfilter.test(busMessage));
        Assert.assertTrue((boolean)summaryfilter.test(alarmMessage));
        Assert.assertTrue((boolean)summaryfilter.test(superAlarmMessage));
        Assert.assertFalse((boolean)summaryfilter.test(statusMessage));
        Assert.assertFalse((boolean)notTempSummaryFilter.test(busMessage));
        Assert.assertFalse((boolean)notTempSummaryFilter.test(alarmMessage));
        Assert.assertFalse((boolean)notTempSummaryFilter.test(superAlarmMessage));
        Assert.assertTrue((boolean)notTempSummaryFilter.test(statusMessage));
    }

    @Test
    public void testCompositeFiltering() {
        BaseBusMessage busMessage = new BaseBusMessage("This is the summary: temp");
        busMessage.setOriginAgentInfo(new AgentInfo("someOrigin", AgentInfo.AgentType.CONSOLE));
        AlarmBusMessage alarmMessage = new AlarmBusMessage("[ALARM] out of value: temp");
        alarmMessage.setOriginAgentInfo(new AgentInfo("someOtherOrigin", AgentInfo.AgentType.CONSOLE));
        SuperAlarmBusMessage superAlarmMessage = new SuperAlarmBusMessage("[ALARM] really out of value: temp");
        superAlarmMessage.setOriginAgentInfo(new AgentInfo("somewhereElseOrigin", AgentInfo.AgentType.CONSOLE));
        StatusBusMessage statusMessage = new StatusBusMessage("[STATUS] ");
        statusMessage.setOriginAgentInfo(new AgentInfo("ccc", AgentInfo.AgentType.CONSOLE));
        Predicate<BaseBusMessage> twoOriginFilter = BusMessageFilterFactory.messageOrigin((String)"someOrigin").or(BusMessageFilterFactory.messageOrigin((String)"someOtherOrigin"));
        Predicate<BaseBusMessage> notFromTwoOriginFilter = BusMessageFilterFactory.messageOrigin((String)"ccc").negate().and(BusMessageFilterFactory.messageOrigin((String)"someOtherOrigin").negate());
        Predicate<BaseBusMessage> fromAnywhereFilter = BusMessageFilterFactory.messageOrigin((String)"ccc").negate().or(BusMessageFilterFactory.messageOrigin((String)"someOtherOrigin").negate());
        Assert.assertTrue((boolean)twoOriginFilter.test(busMessage));
        Assert.assertTrue((boolean)twoOriginFilter.test(alarmMessage));
        Assert.assertFalse((boolean)twoOriginFilter.test(superAlarmMessage));
        Assert.assertFalse((boolean)twoOriginFilter.test(statusMessage));
        Assert.assertTrue((boolean)notFromTwoOriginFilter.test(busMessage));
        Assert.assertFalse((boolean)notFromTwoOriginFilter.test(alarmMessage));
        Assert.assertTrue((boolean)notFromTwoOriginFilter.test(superAlarmMessage));
        Assert.assertFalse((boolean)notFromTwoOriginFilter.test(statusMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.test(busMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.test(alarmMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.test(superAlarmMessage));
        Assert.assertTrue((boolean)fromAnywhereFilter.test(statusMessage));
        Predicate<BaseBusMessage> onlyAlarmsFromAnOrigin = BusMessageFilterFactory.messageOrigin((String)"someOtherOrigin").and(BusMessageFilterFactory.messageClass(AlarmBusMessage.class));
        Assert.assertFalse((boolean)onlyAlarmsFromAnOrigin.test(busMessage));
        Assert.assertTrue((boolean)onlyAlarmsFromAnOrigin.test(alarmMessage));
        Assert.assertFalse((boolean)onlyAlarmsFromAnOrigin.test(superAlarmMessage));
        Assert.assertFalse((boolean)onlyAlarmsFromAnOrigin.test(statusMessage));
    }
}

