package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.function.Predicate;

import org.lsst.ccs.bus.messages.BusMessage;

public class BusMessageFilterFactory {

    /**
     * Create BusMessageFilter on the origin of a BusMessage. The filter will
     * select BusMessages from the provided origin.
     *
     * @param <T>
     * @param <D>
     * @param origin
     * The origin of the desired BusMessages
     * @return APredicate<BusMessage> on the origin of a BusMessage.
     *
     */
    public static <T extends Serializable, D> Predicate<BusMessage<? extends Serializable, ?>> messageOrigin(
            String origin) {
        return (bm) -> (origin == null) || ("".equals(origin)) || bm.getOriginAgentInfo().getName().equals(origin);
    }

    /**
     * Create BusMessageFilter on the class of the object embedded in a
     * StatusMessage. The filter will select StatusMessages that contain an
     * object that can be assigned from the provided clazz.
     *
     * @param <T>
     * @param <D>
     * @param clazz
     * The clazz of the desired object embedded in a StatusMessages
     * @return A BusMessageFilter on the class of an object embedded in a
     * StatusMessage.
     *
     */
    public static <T extends Serializable, D> Predicate<BusMessage<? extends Serializable, ?>> embeddedObjectClass(Class<?> clazz) {
        return (bm) -> bm.getClassName().equals(clazz.getName());
    }

    /**
     * Create BusMessageFilter on the class of a BusMessage. The filter will
     * select BusMessages that can be assigned from the provided clazz.
     *
     * @param <T>
     * @param <D>
     * @param clazz
     * The clazz of the desired BusMessages
     * @return A BusMessageFilter on the origin of a BusMessage.
     *
     */
	// public static <T extends Serializable, D> Predicate<BusMessage<T, D>>
    // messageClass(
    // Class<? super BusMessage<T, D>> clazz) {
    public static <T extends Serializable, D> Predicate<BusMessage<? extends Serializable, ?>> messageClass(Class<?> clazz) {
        return (bm) -> clazz.isInstance(bm);

    }

}
