/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.EnumMap;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.AbstractDispatcher;
import org.lsst.ccs.messaging.util.Dispatcher;

public class LegacyDispatcher
extends AbstractDispatcher {
    private final EnumMap<Bus, Object> busLocks = new EnumMap(Bus.class);
    private volatile boolean off = true;

    public LegacyDispatcher(String args) {
        super(args);
        for (Bus bus : Bus.values()) {
            this.busLocks.put(bus, new Object());
        }
        this.config = null;
    }

    @Override
    public void initialize() {
        this.off = false;
    }

    @Override
    public void shutdown() {
        this.off = true;
        super.shutdown();
    }

    @Override
    public void in(Runnable runnable, Bus bus, String ... agents) {
        Dispatcher.Task task;
        if (this.off) {
            return;
        }
        Dispatcher.Task task2 = task = runnable instanceof Dispatcher.Task ? (Dispatcher.Task)runnable : null;
        if (task != null) {
            task.stageEnded(Dispatcher.Stage.START);
            task.stageEnded(Dispatcher.Stage.WAIT);
        }
        runnable.run();
        if (task != null) {
            task.stageEnded(Dispatcher.Stage.RUN);
            task.stageEnded(Dispatcher.Stage.SUBMIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void out(Runnable runnable, Bus bus, Dispatcher.Order order) {
        Dispatcher.Task task;
        if (this.off) {
            throw new TransportStateException();
        }
        Dispatcher.Task task2 = task = runnable instanceof Dispatcher.Task ? (Dispatcher.Task)runnable : null;
        if (task != null) {
            task.stageEnded(Dispatcher.Stage.START);
            task.stageEnded(Dispatcher.Stage.WAIT);
        }
        Object object = this.busLocks.get(bus);
        synchronized (object) {
            runnable.run();
        }
        if (task != null) {
            task.stageEnded(Dispatcher.Stage.RUN);
            task.stageEnded(Dispatcher.Stage.SUBMIT);
        }
    }
}

