/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.utilities.scheduler.BasicThreadFactory;

public abstract class AbstractDispatcher
implements Dispatcher {
    private final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    protected HashMap<String, String> config;
    protected final ScheduledExecutorService serviceExec;
    private final CopyOnWriteArrayList<Dispatcher.Listener> listeners = new CopyOnWriteArrayList();
    protected final Map<String, Alert> alerts = Collections.synchronizedMap(new HashMap());

    protected AbstractDispatcher(String args) {
        this.config = new HashMap();
        if (args != null && !args.isEmpty()) {
            for (String arg : args.split("\\&")) {
                String key;
                String[] ss = arg.split("=");
                if (ss.length >= 3 || (key = ss[0].trim()).isEmpty()) continue;
                String value = ss.length == 2 ? ss[1].trim() : "";
                this.config.put(key, value);
            }
        }
        this.serviceExec = Executors.newScheduledThreadPool(1, (ThreadFactory)new BasicThreadFactory("Dispatcher Service", null, true));
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutdown() {
        try {
            this.serviceExec.shutdown();
            this.serviceExec.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    public void addListener(Dispatcher.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Dispatcher.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireEvent(Dispatcher.Event event) {
        try {
            this.serviceExec.execute(() -> this.deliverEvent(event));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected void deliverEvent(Dispatcher.Event event) {
        this.listeners.forEach(listener -> {
            try {
                listener.onEvent(event);
            }
            catch (RuntimeException x) {
                this.getLogger().log(Level.WARNING, "Error notifying " + listener + " of " + event.getClass().getSimpleName() + " event.", x);
            }
        });
    }

    @Override
    public void raiseAlert(String id, AlertState severity, String cause) {
        try {
            this.serviceExec.execute(() -> {
                Alert alert = this.alerts.get(id);
                if (alert == null) {
                    return;
                }
                Dispatcher.AlertEvent event = new Dispatcher.AlertEvent(this, alert, severity, cause);
                this.deliverEvent(event);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void raiseAlert(Alert alert, AlertState severity, String cause) {
        try {
            this.serviceExec.execute(() -> {
                Dispatcher.AlertEvent event = new Dispatcher.AlertEvent(this, alert, severity, cause);
                this.deliverEvent(event);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public List<Alert> getRegisteredAlerts() {
        return new ArrayList<Alert>(this.alerts.values());
    }

    @Override
    public void registerAlert(Alert alert) {
        this.alerts.put(alert.getAlertId(), alert);
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    protected final int getIntArg(String key, int defaultValue) {
        try {
            String s = this.config.get(key);
            return s == null ? defaultValue : Integer.parseInt(s);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Illegal value for " + key, x);
        }
    }

    protected final boolean getBooleanArg(String key) {
        return this.config.containsKey(key);
    }

    protected final int[] getIntArrayArg(String key, int defaultValue, int length) {
        try {
            int[] out = new int[length];
            String s = this.config.get(key);
            if (s == null) {
                Arrays.fill(out, defaultValue);
            } else {
                String[] ss = s.split(",");
                if (ss.length != length) {
                    throw new IllegalArgumentException("Illegal value for " + key);
                }
                for (int i = 0; i < length; ++i) {
                    out[i] = Integer.parseInt(ss[i].trim());
                }
            }
            return out;
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Illegal value for " + key, x);
        }
    }

    protected final int[] getIntArrayArg(String key, int[] defaultValue) {
        try {
            String s = this.config.get(key);
            if (s == null) {
                return defaultValue;
            }
            String[] ss = s.split(",");
            int length = ss.length;
            if (defaultValue.length != 0 && length != defaultValue.length) {
                throw new IllegalArgumentException("Illegal value for " + key);
            }
            int[] out = new int[length];
            for (int i = 0; i < length; ++i) {
                out[i] = Integer.parseInt(ss[i].trim());
            }
            return out;
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Illegal value for " + key, x);
        }
    }

    public static abstract class Task
    implements Dispatcher.Task {
        protected final BusMessage busMessage;
        protected final long refTime;

        public Task(BusMessage busMessage, long referenceTime) {
            this.busMessage = busMessage;
            this.refTime = referenceTime;
        }

        public Task(BusMessage busMessage) {
            this(busMessage, System.currentTimeMillis());
        }

        public BusMessage getBusMessage() {
            return this.busMessage;
        }

        public long getRefTime() {
            return this.refTime;
        }

        @Override
        public void stageEnded(Dispatcher.Stage stage) {
        }
    }
}

