package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.CommandNack;

/**
 * Exception thrown by utility classes to indicate that a command has been
 * rejected. It internally contains The CommandNack that caused the rejection.
 * 
 * @author The LSST CCS Team
 */
public final class CommandRejectedException extends Exception {
    
    private final CommandNack commandNack;

    /**
     * Construct a CommandRejectedException from the corresponding CommandNack.
     * 
     * @param negativeAck The CommandNack that explains the rejection.
     */
    public CommandRejectedException(CommandNack negativeAck) {
        super(negativeAck.getReason());
        this.commandNack = negativeAck;
    }

    /**
     * Get the CommandNack that explains the rejection of the command.
     * 
     * @return The CommandNack.
     */
    public CommandNack getCommandNack() {
        return commandNack;
    }

    @Override
    public String toString() {
        return commandNack.getReason()+"\n"+super.toString() + " " + commandNack;
    }
}
