/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.EnumMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.AbstractDispatcher;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.messaging.util.KeyQueueExecutor;

public class MultiQueueDispatcher
extends AbstractDispatcher {
    private final AtomicLong taskID = new AtomicLong();
    private volatile boolean off = true;
    private final EnumMap<Bus, Object> inExecutors;
    private final EnumMap<Bus, ExecutorService> outNormExecutors;
    private final ThreadPoolExecutor outOobCcExec;
    private final ThreadPoolExecutor oobExec;

    public MultiQueueDispatcher(String ... args) {
        super(args);
        EnumMap<Bus, Integer> defThreads = new EnumMap<Bus, Integer>(Bus.class);
        defThreads.put(Bus.COMMAND, 1);
        defThreads.put(Bus.LOG, 1);
        defThreads.put(Bus.STATUS, 10);
        this.inExecutors = new EnumMap(Bus.class);
        for (Bus bus : Bus.values()) {
            int n;
            Integer threads = this.getIntegerArg("in_" + bus.name().toLowerCase() + "_threads", args);
            int n2 = n = threads == null ? ((Integer)defThreads.get(bus)).intValue() : threads.intValue();
            if (n == 1) {
                this.inExecutors.put(bus, (Object)Executors.newSingleThreadExecutor(new TFactory("MESSAGING_IN_" + bus)));
                continue;
            }
            this.inExecutors.put(bus, (Object)new KeyQueueExecutor("MESSAGING_IN_" + bus, n));
        }
        this.outNormExecutors = new EnumMap(Bus.class);
        for (Bus bus : Bus.values()) {
            this.outNormExecutors.put(bus, Executors.newSingleThreadExecutor(new TFactory("MESSAGING_OUT_" + bus)));
        }
        this.outOobCcExec = new ThreadPoolExecutor(2, 2, 70L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TFactory("MESSAGING_OUT_OOB_CC"));
        this.outOobCcExec.allowCoreThreadTimeOut(true);
        this.oobExec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 70L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new TFactory("MESSAGING_OOB"));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.off = false;
    }

    @Override
    public void shutdown() {
        this.off = true;
        this.oobExec.shutdown();
        this.outOobCcExec.shutdown();
        this.outNormExecutors.values().forEach(exec -> exec.shutdown());
        this.inExecutors.values().forEach(exec -> {
            if (exec instanceof KeyQueueExecutor) {
                ((KeyQueueExecutor)exec).shutdownNow();
            } else {
                ((ExecutorService)exec).shutdownNow();
            }
        });
        try {
            this.oobExec.awaitTermination(1L, TimeUnit.MINUTES);
            this.outOobCcExec.awaitTermination(1L, TimeUnit.MINUTES);
            for (ExecutorService executorService : this.outNormExecutors.values()) {
                executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            for (Object object : this.inExecutors.values()) {
                if (object instanceof KeyQueueExecutor) {
                    ((KeyQueueExecutor)object).awaitTermination(1L, TimeUnit.MINUTES);
                    continue;
                }
                ((ExecutorService)object).awaitTermination(1L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        super.shutdown();
    }

    void drainAndShutdown() {
        this.off = true;
        this.oobExec.shutdown();
        this.outOobCcExec.shutdown();
        this.outNormExecutors.values().forEach(exec -> exec.shutdown());
        this.inExecutors.values().forEach(exec -> {
            if (exec instanceof KeyQueueExecutor) {
                ((KeyQueueExecutor)exec).shutdown();
            } else {
                ((ExecutorService)exec).shutdown();
            }
        });
        try {
            this.oobExec.awaitTermination(1L, TimeUnit.MINUTES);
            this.outOobCcExec.awaitTermination(1L, TimeUnit.MINUTES);
            for (ExecutorService executorService : this.outNormExecutors.values()) {
                executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            for (Object object : this.inExecutors.values()) {
                if (object instanceof KeyQueueExecutor) {
                    ((KeyQueueExecutor)object).awaitTermination(1L, TimeUnit.MINUTES);
                    continue;
                }
                ((ExecutorService)object).awaitTermination(1L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        super.shutdown();
    }

    @Override
    public void in(Runnable run, Bus bus, String ... agents) {
        if (this.off) {
            return;
        }
        long id = this.taskID.getAndIncrement();
        long time = System.currentTimeMillis();
        Dispatcher.Order order = agents == null ? Dispatcher.Order.OOB : (agents.length == 0 ? Dispatcher.Order.OOB_CC : Dispatcher.Order.NORM);
        this.report(run, id, true, bus, order, time, Dispatcher.Stage.START);
        Task task = new Task(id, run, true, bus, order, time);
        try {
            switch (order) {
                case NORM: 
                case OOB_CC: {
                    Object exec = this.inExecutors.get(bus);
                    if (exec instanceof KeyQueueExecutor) {
                        ((KeyQueueExecutor)exec).execute(task, agents);
                        break;
                    }
                    ((ExecutorService)exec).execute(task);
                    break;
                }
                case OOB: {
                    this.oobExec.execute(task);
                }
            }
        }
        catch (RejectedExecutionException x) {
            try {
                throw new TransportStateException(x);
            }
            catch (Throwable throwable) {
                this.report(run, id, true, bus, order, System.currentTimeMillis() - time, Dispatcher.Stage.SUBMIT);
                throw throwable;
            }
        }
        this.report(run, id, true, bus, order, System.currentTimeMillis() - time, Dispatcher.Stage.SUBMIT);
    }

    @Override
    public void out(Runnable run, Bus bus, Dispatcher.Order order) {
        if (this.off) {
            throw new TransportStateException();
        }
        long id = this.taskID.getAndIncrement();
        long time = System.currentTimeMillis();
        this.report(run, id, false, bus, order, time, Dispatcher.Stage.START);
        Task task = new Task(id, run, false, bus, order, time);
        try {
            switch (order) {
                case NORM: {
                    this.outNormExecutors.get(bus).execute(task);
                    break;
                }
                case OOB_CC: {
                    this.outOobCcExec.execute(task);
                    break;
                }
                case OOB: {
                    this.oobExec.execute(task);
                }
            }
        }
        catch (RejectedExecutionException x) {
            try {
                throw new TransportStateException();
            }
            catch (Throwable throwable) {
                this.report(run, id, false, bus, order, System.currentTimeMillis() - time, Dispatcher.Stage.SUBMIT);
                throw throwable;
            }
        }
        this.report(run, id, false, bus, order, System.currentTimeMillis() - time, Dispatcher.Stage.SUBMIT);
    }

    private class TFactory
    implements ThreadFactory {
        private final ThreadFactory delegate = Executors.defaultThreadFactory();
        private final String name;

        TFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.delegate.newThread(r);
            thread.setDaemon(true);
            thread.setName(this.name);
            thread.setUncaughtExceptionHandler((t, x) -> MultiQueueDispatcher.this.getLogger().warn((Object)("Exception thrown from messaging executor " + this.name), x));
            return thread;
        }
    }

    private class Task
    implements Runnable {
        private final long id;
        private final Runnable runnable;
        private final boolean incoming;
        private final Bus bus;
        private final Dispatcher.Order order;
        private long time = System.currentTimeMillis();

        Task(long id, Runnable runnable, boolean incoming, Bus bus, Dispatcher.Order order, long time) {
            this.id = id;
            this.runnable = runnable;
            this.incoming = incoming;
            this.bus = bus;
            this.order = order;
            this.time = time;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block10: {
                long current2333333332 = System.currentTimeMillis();
                MultiQueueDispatcher.this.report(this.runnable, this.id, this.incoming, this.bus, this.order, current2333333332 - this.time, Dispatcher.Stage.WAIT);
                this.time = current2333333332;
                this.runnable.run();
                try {
                    MultiQueueDispatcher.this.report(this.runnable, this.id, this.incoming, this.bus, this.order, System.currentTimeMillis() - this.time, Dispatcher.Stage.RUN);
                }
                catch (Exception current2333333332) {}
                break block10;
                catch (Exception x) {
                    try {
                        MultiQueueDispatcher.this.getLogger().warn((Object)"Error sending message", (Throwable)x);
                    }
                    catch (Throwable throwable) {
                        try {
                            MultiQueueDispatcher.this.report(this.runnable, this.id, this.incoming, this.bus, this.order, System.currentTimeMillis() - this.time, Dispatcher.Stage.RUN);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        MultiQueueDispatcher.this.report(this.runnable, this.id, this.incoming, this.bus, this.order, System.currentTimeMillis() - this.time, Dispatcher.Stage.RUN);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

