/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicLong;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.AbstractDispatcher;
import org.lsst.ccs.messaging.util.Dispatcher;

public class LegacyDispatcher
extends AbstractDispatcher {
    private final AtomicLong taskID = new AtomicLong();
    private final EnumMap<Bus, Object> busLocks = new EnumMap(Bus.class);
    private volatile boolean off = true;

    public LegacyDispatcher(String ... args) {
        super(args);
        for (Bus bus : Bus.values()) {
            this.busLocks.put(bus, new Object());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.off = false;
    }

    @Override
    public void shutdown() {
        this.off = true;
        super.shutdown();
    }

    @Override
    public void in(Runnable task, Bus bus, String ... agents) {
        if (this.off) {
            return;
        }
        long time = System.currentTimeMillis();
        Dispatcher.Order order = agents == null ? Dispatcher.Order.OOB : (agents.length == 0 ? Dispatcher.Order.OOB_CC : Dispatcher.Order.NORM);
        long id = this.taskID.getAndIncrement();
        this.report(task, id, true, bus, order, time, Dispatcher.Stage.START);
        task.run();
        this.report(task, id, true, bus, order, System.currentTimeMillis() - time, Dispatcher.Stage.RUN, Dispatcher.Stage.SUBMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void out(Runnable task, Bus bus, Dispatcher.Order order) {
        long runTime;
        if (this.off) {
            throw new TransportStateException();
        }
        long submitTime = System.currentTimeMillis();
        long id = this.taskID.getAndIncrement();
        this.report(task, id, false, bus, order, submitTime, Dispatcher.Stage.START);
        Object object = this.busLocks.get(bus);
        synchronized (object) {
            runTime = System.currentTimeMillis();
            this.report(task, id, false, bus, order, runTime - submitTime, Dispatcher.Stage.WAIT);
            task.run();
        }
        this.report(task, id, false, bus, order, System.currentTimeMillis() - runTime, Dispatcher.Stage.RUN, Dispatcher.Stage.SUBMIT);
    }
}

