package org.lsst.ccs.messaging;

/**
 * Interface to be implemented by a BusMessagingLayer that provides 
 * cluster membership notifications natively.
 * 
 * @author The LSST CCS Team
 */
public interface HasClusterMembershipNotifications {


    public void addClusterMembershipListener(ClusterMembershipListener listener);

    public void removeClusterMembershipListener(ClusterMembershipListener listener);
    
    public default void clear() {};
    
    public default boolean hasInternalHeartbeat() {
        return false;
    }
    
}
