/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.ClusterDisconnectionsListener;
import org.lsst.ccs.messaging.HasClusterDisconnectionNotifications;
import org.lsst.ccs.messaging.StatusMessageListener;

class DefaultClusterMembershipNotifier
implements StatusMessageListener,
HasClusterDisconnectionNotifications {
    private final AgentPresenceListenerDelayedNotification delayedNotification = new AgentPresenceListenerDelayedNotification();
    private final Map<AgentInfo, TimeoutTask> mapAgents = new ConcurrentHashMap<AgentInfo, TimeoutTask>();
    private final String agentName;
    private final Timer timer = new Timer(true);
    private final Object agentsLock = new Object();
    private static final int SUSPICION_LENGTH = 10;
    private static final Logger LOG = Logger.getLogger(DefaultClusterMembershipNotifier.class.getName());
    private final List<ClusterDisconnectionsListener> disconnectionListeners = new CopyOnWriteArrayList<ClusterDisconnectionsListener>();

    public DefaultClusterMembershipNotifier(String agentName) {
        this.agentName = agentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.agentsLock;
        synchronized (object) {
            for (TimerTask timerTask : this.mapAgents.values()) {
                if (timerTask == null) continue;
                timerTask.cancel();
            }
            this.delayedNotification.stopNotifications();
            this.mapAgents.clear();
        }
    }

    @Override
    public void onStatusMessage(StatusMessage s) {
        AgentInfo a = s.getOriginAgentInfo();
        if (a == null) {
            return;
        }
        int broadCastPeriod = -1;
        if (s instanceof StatusHeartBeat) {
            StatusHeartBeat hb = (StatusHeartBeat)s;
            broadCastPeriod = hb.getStatusBroadcastPeriod();
        }
        if (!s.getState().isInState((Enum)PhaseState.OFF_LINE)) {
            this.removeAgent(a, false);
        } else {
            this.updateAgent(a, broadCastPeriod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAgent(AgentInfo agent, boolean sendNotification) {
        LOG.log(Level.FINE, "Removing agent {0}", agent.getName());
        TimeoutTask t = null;
        Object object = this.agentsLock;
        synchronized (object) {
            t = this.mapAgents.remove(agent);
            if (t != null) {
                t.cancel();
                if (sendNotification) {
                    this.delayedNotification.removeAgent(agent);
                }
            }
        }
        if (t == null) {
            LOG.log(Level.FINEST, "removing agent with null timer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgent(AgentInfo a, int broadcastPeriod) {
        LOG.log(Level.FINE, "Upating {0}", a.getName());
        Object object = this.agentsLock;
        synchronized (object) {
            TimeoutTask task = this.mapAgents.get(a);
            if (task != null) {
                task.cancel();
                if (broadcastPeriod == -1) {
                    broadcastPeriod = task.getBroadcastPeriod();
                }
                task = new TimeoutTask(a, broadcastPeriod);
            } else {
                if (broadcastPeriod == -1) {
                    broadcastPeriod = 500;
                }
                task = new TimeoutTask(a, broadcastPeriod);
            }
            this.mapAgents.put(a, task);
            this.timer.schedule((TimerTask)task, 10000 * broadcastPeriod);
        }
        LOG.log(Level.FINER, "reset timer for agent {0} to {1}", new Object[]{a.getName(), broadcastPeriod});
    }

    @Override
    public void addClusterMembershipListener(ClusterDisconnectionsListener listener) {
        this.disconnectionListeners.add(listener);
    }

    @Override
    public void removeClusterMembershipListener(ClusterDisconnectionsListener listener) {
        this.disconnectionListeners.remove(listener);
    }

    class AgentPresenceListenerDelayedNotification {
        private final List<AgentInfo> leavingAgents = new CopyOnWriteArrayList<AgentInfo>();
        private static final long DELAYED_WAIT_PERIOD = 1000L;
        private final Object notificationLock = new Object();
        private DelayedNotificationTask notificationTask;
        private volatile boolean isStopped = false;

        AgentPresenceListenerDelayedNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAgent(AgentInfo agent) {
            Object object = this.notificationLock;
            synchronized (object) {
                if (this.isStopped) {
                    return;
                }
                if (this.leavingAgents.contains(agent)) {
                    return;
                }
                LOG.log(Level.FINE, "{0} Removing agent {1} to list of notifications", new Object[]{DefaultClusterMembershipNotifier.this.agentName, agent});
                this.leavingAgents.add(agent);
                if (this.notificationTask != null) {
                    this.notificationTask.cancel();
                }
                this.notificationTask = new DelayedNotificationTask();
                DefaultClusterMembershipNotifier.this.timer.schedule((TimerTask)this.notificationTask, 1000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopNotifications() {
            Object object = this.notificationLock;
            synchronized (object) {
                this.isStopped = true;
                if (this.notificationTask != null) {
                    this.notificationTask.cancel();
                }
                this.leavingAgents.clear();
            }
        }

        private class DelayedNotificationTask
        extends TimerTask {
            private DelayedNotificationTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AgentPresenceListenerDelayedNotification.this.notificationLock;
                synchronized (object) {
                    if (AgentPresenceListenerDelayedNotification.this.isStopped) {
                        return;
                    }
                    LOG.log(Level.FINE, "{0} Submitting notification for agents leaving: {1}", new Object[]{DefaultClusterMembershipNotifier.this.agentName, AgentPresenceListenerDelayedNotification.this.leavingAgents});
                    ArrayList<String> toSubmit = new ArrayList<String>();
                    if (!AgentPresenceListenerDelayedNotification.this.leavingAgents.isEmpty()) {
                        AgentPresenceListenerDelayedNotification.this.leavingAgents.forEach(a -> toSubmit.add(a.getName()));
                        for (ClusterDisconnectionsListener l : DefaultClusterMembershipNotifier.this.disconnectionListeners) {
                            l.membersLeft(toSubmit);
                        }
                    }
                    AgentPresenceListenerDelayedNotification.this.leavingAgents.clear();
                }
            }
        }
    }

    class TimeoutTask
    extends TimerTask {
        private final AgentInfo agent;
        private final int broadcastPeriod;

        TimeoutTask(AgentInfo agent, int broadcastPeriod) {
            this.agent = agent;
            this.broadcastPeriod = broadcastPeriod;
        }

        int getBroadcastPeriod() {
            return this.broadcastPeriod;
        }

        @Override
        public void run() {
            DefaultClusterMembershipNotifier.this.removeAgent(this.agent, true);
        }
    }
}

