package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.command.annotations.Command;

/**
 * A dummy lock used for preliminary implementation of the agent lock service.
 * @author LSST CCS Team
 */
public class DummyLock implements AgentLock, Serializable {
    private static final long serialVersionUID = 5818640455315154768L;
    
    private final String agentName;
    
    private final String ownerAgent;
    
    private final String userId = "";
    
    private final int maxLevel = Command.NOT_DEFINED;
    
    public DummyLock(String agentName, String ownerAgent) {
        this.agentName = agentName;
        this.ownerAgent = ownerAgent;
    }
    
    @Override
    public String getAgentName() {
        return agentName;
    }
    
    @Override
    public String getOwnerAgentName() {
        return ownerAgent;
    }

    @Override
    public int getMaxLevel() {
        return maxLevel;
    }

    @Override
    public String getUserID() {
        return userId;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.agentName);
        hash = 67 * hash + Objects.hashCode(this.userId);
        hash = 67 * hash + this.maxLevel;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DummyLock other = (DummyLock) obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.userId, other.userId)) {
            return false;
        }
        if (this.maxLevel != other.maxLevel) {
            return false;
        }
        return true;
    }
    
}
