package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.CommandNack;

/**
 * Originator of a command.
 * Once an agent receives the reply of a command, it passes it to its list of 
 * command originators. The originator with the matching correlation ID can then
 * process the command response.
 * 
 * TODO: Add some javadoc to the methods.
 * 
 * @author emarin
 */
public interface CommandOriginator {
    void processAck(CommandAck ack);
    void processResult (CommandResult result);
    void processNack(CommandNack nack);          
}
