/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.lsst.ccs.messaging.AgentMessagingLayer;

public class CcsTestCaseTemplate {
    protected String transport;
    private BrokerService broker;

    public CcsTestCaseTemplate() {
        this("jgroups:udp_ccs");
    }

    public CcsTestCaseTemplate(String transport) {
        this.setTransport(transport);
    }

    private void setTransport(String transport) {
        this.transport = transport;
        System.setProperty("org.lsst.ccs.transport", transport);
    }

    protected String getTransport() {
        return this.transport;
    }

    @Before
    public void initServers() {
        if (this.transport.startsWith("jms")) {
            System.setProperty("org.apache.activemq.default.directory.prefix", "./target/");
            this.broker = new BrokerService();
            try {
                this.broker.addConnector("tcp://localhost:34211");
                this.broker.start();
                this.broker.waitUntilStarted();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @After
    public void tearDownServers() {
        if (this.transport.startsWith("jms")) {
            try {
                this.broker.stop();
                this.broker.waitUntilStopped();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @BeforeClass
    public static void setupEnvironment() {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }

    @AfterClass
    public static void printMessagingLayerInformation() throws Exception {
        List messagingAccesses = AgentMessagingLayer.getMessagingAccesses();
        if (messagingAccesses.size() > 0) {
            System.out.println("*********************************");
            System.out.println("***** MessagingAccess left open: " + messagingAccesses.size());
            System.out.println();
            int count = 0;
            for (AgentMessagingLayer msgAcc : messagingAccesses) {
                System.out.println(" -" + ++count + "-");
                AgentMessagingLayer.printMessagingAccessInfo((AgentMessagingLayer)msgAcc);
                System.out.println();
            }
            System.out.println("*********************************");
        }
    }
}

