package org.lsst.ccs.bus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 */
public class BusMessagingFactory  extends MessagingFactory{
    
    protected BusMessagingLayer busMessagingLayer ;
    protected Map<String,InnerFactory> map = new HashMap<String, InnerFactory>() ;

    class InnerFactory extends MessagingFactory {
        String subSystem ;
        BusApplicationLayer layer ;
        protected boolean[] registered = new boolean[Bus.values().length];
        boolean autoReply = true ;

        InnerFactory(String subSystem, BusMessagingLayer transport) {
            this.subSystem = subSystem;
            this.layer = new BusApplicationLayer(subSystem, transport);
        }

        @Override
        public synchronized void addCommandListener(CommandListener l) {
            if(! registered[Bus.COMMAND.ordinal()]){
                try {
                    layer.registerToCommand();
                } catch (IOException e) {
                    //TODO: change that!
                    throw new RuntimeException(e) ;
                }
                registered[Bus.COMMAND.ordinal()] = true ;
            }
            layer.addCommandListener(l);
        }

        public synchronized void removeCommandListener(CommandListener l) {
            layer.removeCommandListener(l);
        }

        @Override
        public  synchronized void addStatusListener(StatusListener l) {
            if(! registered[Bus.STATUS.ordinal()]){
                try {
                    layer.registerToStatus();
                } catch (IOException e) {
                    throw new RuntimeException(e) ;
                }
                registered[Bus.STATUS.ordinal()] = true ;
            }
            layer.addStatusListener(l);
        }
        public synchronized void removeStatusListener(StatusListener l) {
            layer.removeStatusListener(l);
        }

        @Override
        public synchronized void addLogListener(LogListener l) {
            if(! registered[Bus.LOG.ordinal()]){
                try {
                    layer.registerToLog();
                } catch (IOException e) {
                    throw new RuntimeException(e) ;
                }
                registered[Bus.LOG.ordinal()] = true ;
            }
            layer.addLogListener(l);
        }
        public synchronized void removeLogListener(LogListener l) {
            layer.removeLogListener(l);
        }

        @Override
        public void addCommandListener(CommandListener l, String selector) {
            addCommandListener(l);
        }

        @Override
        public void addStatusListener(StatusListener l, String selector) {
            addStatusListener(l);
        }

        @Override
        public void addLogListener(LogListener l, String selector) {
            addLogListener(l);
        }

        @Override
        public synchronized void sendCommand(Command cmd) {
            try {
                if(! registered[Bus.COMMAND.ordinal()]){
                    layer.registerToCommand();
                    registered[Bus.COMMAND.ordinal()] = true ;
                }
                //TODO: check if Command without Origin!
                layer.sendCommand(cmd);
            } catch (IOException e) {
                //TODO:change that!!!
              if(e instanceof DestinationsException) {
                  System.out.println(" Log WARN: " + e);
                  // toDO : wit until lock arbitrator
                  // throw new RuntimeException(e);
              } else {
                throw new RuntimeException(e);
              }
            }
        }

        @Override
        public synchronized void sendStatus(Status status) {
            try {
                if(! registered[Bus.STATUS.ordinal()]){
                    layer.registerToStatus();
                    registered[Bus.STATUS.ordinal()] = true ;
                }
                layer.sendStatus(status);
            } catch (IOException e) {
                //TODO:change that!!!
                throw new RuntimeException(e);
            }
            //To change body of implemented methods use File | Settings | File Templates.
        }

        @Override
        public synchronized void sendLogEvent(LogEvent evt) {
            try {
                if(! registered[Bus.LOG.ordinal()]){
                    layer.registerToLog();
                    registered[Bus.LOG.ordinal()] = true ;
                }
                layer.sendLogEvent(evt);
            } catch (IOException e) {
                //TODO:change that!!!
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getToken() {
            return layer.getToken();
        }

        @Override
        public void reply(CommandAckOrReply cmd) {
            try {
                layer.reply(cmd);
            } catch (IOException e) {
                //TODO:change that!!!
                throw new RuntimeException(e);
            }
        }

        @Override
        public void noAutoReply() {
            autoReply = false ;
            //To change body of implemented methods use File | Settings | File Templates.
        }

        // TODO: change that .....
        @Override
        public boolean isReplyRequested(){
            return this.autoReply ;
        }

        @Override
        public void shutdownBusAccess() {
            layer.close() ;

        }
    }
    
    ///////////////////////////////////////// CTOR
    
    public BusMessagingFactory() {
        //String clazzName = System.getProperty("lsst.messaging.messagingLayer", "org.lsst.ccs.bus.jgroups.JGroupsBusMessagingLayer");
        String protocolProperty = System.getProperty("lsst.ccs.transport", "jgroups:udp_ccs:") ;
        String transportPropsProperty = System.getProperty("lsst.ccs.transport.properties", "");
        try {
        //busMessagingLayer = (BusMessagingLayer) Class.forName(clazzName).newInstance();
            busMessagingLayer = TransportManager.getConnection(protocolProperty,transportPropsProperty) ;
        } catch (Exception exc) {
            //todo: change this exception
            throw new RuntimeException(exc) ;
        }
    }
    
    @Override
    public  synchronized MessagingFactory forSubsystem(String name) {
        InnerFactory fact = map.get(name) ;
        if(fact == null ) {
            fact = new InnerFactory(name, busMessagingLayer);
            map.put(name, fact) ;
        }
        return fact ;
    }
    ///////////////////////////////////////// METHODS
    
    @Override
    public void addCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
    public synchronized void removeCommandListener(CommandListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addStatusListener(StatusListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
    public synchronized void removeStatusListener(StatusListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    public synchronized void removeLogListener(LogListener l) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addCommandListener(CommandListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void addStatusListener(StatusListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void addLogListener(LogListener l, String selector) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)");
    }

    @Override
    public void sendCommand(Command cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void sendStatus(Status status) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void sendLogEvent(LogEvent evt) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public String getToken() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
        //return null;
    }

    @Override
    public void reply(CommandAckOrReply cmd) {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }

    @Override
    public void noAutoReply() {
        throw new UnsupportedOperationException("incorrect call on factory: use forSubsystem(name)") ;
    }
}
