package org.lsst.ccs.messaging.jms;

import java.util.HashMap;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.TransportManager;

/**
 */
public class JMSTransportManager extends TransportManager {
    static final HashMap<String, JMSBusMessagingLayer> map = new HashMap<String, JMSBusMessagingLayer>() ;
    @Override
    public BusMessagingLayer getInstance(String protocolString, String propertiesString) {

        if (protocolString.startsWith("jms")) {
            JMSBusMessagingLayer res = map.get("jms");
            if (res==null){
                JMSBusMessagingLayer layer = new JMSBusMessagingLayer();
            // We are not caching
            //    map.put("jms",layer);
            return layer;
            }
            else {
                return res;
            }

        } else {
            return null;
        }

    }
}
